/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.griffin.engine.table.parquet.RowGroupStatBuffers;
import io.questdb.std.Chars;
import io.questdb.std.DirectIntList;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectString;

public class PartitionDecoder
implements QuietCloseable {
    private static final long COLUMNS_PTR_OFFSET;
    private static final long COLUMN_COUNT_OFFSET;
    private static final long COLUMN_IDS_OFFSET;
    private static final long COLUMN_RECORD_NAME_PTR_OFFSET;
    private static final long COLUMN_RECORD_NAME_SIZE_OFFSET;
    private static final long COLUMN_RECORD_TYPE_OFFSET;
    private static final long COLUMN_STRUCT_SIZE;
    private static final long ROW_COUNT_OFFSET;
    private static final long ROW_GROUP_COUNT_OFFSET;
    private static final long ROW_GROUP_SIZES_PTR_OFFSET;
    private final ObjectPool<DirectString> directStringPool = new ObjectPool<DirectString>(DirectString::new, 16);
    private final Metadata metadata = new Metadata();
    private long columnsPtr;
    private long fileAddr;
    private long fileSize;
    private long ptr;
    private long rowGroupSizesPtr;

    public static boolean decodeNoNeedToDecodeFlag(long encodedIndex) {
        return (encodedIndex & 1L) == 1L;
    }

    public static int decodeRowGroupIndex(long encodedIndex) {
        return (int)((encodedIndex >> 1) - 1L);
    }

    @Override
    public void close() {
        this.destroy();
        this.fileAddr = 0L;
        this.fileSize = 0L;
    }

    public int decodeRowGroup(RowGroupBuffers rowGroupBuffers, DirectIntList columns, int rowGroupIndex, int rowLo, int rowHi) {
        assert (this.ptr != 0L);
        return PartitionDecoder.decodeRowGroup(this.ptr, rowGroupBuffers.ptr(), columns.getAddress(), (int)(columns.size() >>> 1), rowGroupIndex, rowLo, rowHi);
    }

    public long findRowGroupByTimestamp(long timestamp, long rowLo, long rowHi, int timestampColumnIndex) {
        assert (this.ptr != 0L);
        return PartitionDecoder.findRowGroupByTimestamp(this.ptr, timestamp, rowLo, rowHi, timestampColumnIndex);
    }

    public long getFileAddr() {
        return this.fileAddr;
    }

    public long getFileSize() {
        assert (this.fileSize > 0L || this.fileAddr == 0L);
        return this.fileSize;
    }

    public Metadata metadata() {
        assert (this.ptr != 0L);
        return this.metadata;
    }

    public void of(long addr, long fileSize, int memoryTag) {
        assert (addr != 0L);
        assert (fileSize > 0L);
        this.destroy();
        this.fileAddr = addr;
        this.fileSize = fileSize;
        long allocator = Unsafe.getNativeAllocator(memoryTag);
        this.ptr = PartitionDecoder.create(allocator, addr, fileSize);
        this.columnsPtr = Unsafe.getUnsafe().getLong(this.ptr + COLUMNS_PTR_OFFSET);
        this.rowGroupSizesPtr = Unsafe.getUnsafe().getLong(this.ptr + ROW_GROUP_SIZES_PTR_OFFSET);
        this.metadata.init();
    }

    public void readRowGroupStats(RowGroupStatBuffers statBuffers, DirectIntList columns, int rowGroupIndex) {
        assert (this.ptr != 0L);
        PartitionDecoder.readRowGroupStats(this.ptr, statBuffers.ptr(), columns.getAddress(), (int)(columns.size() >>> 1), rowGroupIndex);
    }

    private static native long columnCountOffset();

    private static native long columnIdsOffset();

    private static native long columnRecordNamePtrOffset();

    private static native long columnRecordNameSizeOffset();

    private static native long columnRecordSize();

    private static native long columnRecordTypeOffset();

    private static native long columnsPtrOffset();

    private static native long create(long var0, long var2, long var4) throws CairoException;

    private static native int decodeRowGroup(long var0, long var2, long var4, int var6, int var7, int var8, int var9) throws CairoException;

    private static native void destroy(long var0);

    private static native long findRowGroupByTimestamp(long var0, long var2, long var4, long var6, int var8);

    private static native long readRowGroupStats(long var0, long var2, long var4, int var6, int var7) throws CairoException;

    private static native long rowCountOffset();

    private static native long rowGroupCountOffset();

    private static native long rowGroupSizesPtrOffset();

    private void destroy() {
        if (this.ptr != 0L) {
            PartitionDecoder.destroy(this.ptr);
            this.ptr = 0L;
            this.columnsPtr = 0L;
            this.rowGroupSizesPtr = 0L;
        }
    }

    static {
        Os.init();
        COLUMN_COUNT_OFFSET = PartitionDecoder.columnCountOffset();
        COLUMNS_PTR_OFFSET = PartitionDecoder.columnsPtrOffset();
        ROW_COUNT_OFFSET = PartitionDecoder.rowCountOffset();
        COLUMN_STRUCT_SIZE = PartitionDecoder.columnRecordSize();
        COLUMN_RECORD_TYPE_OFFSET = PartitionDecoder.columnRecordTypeOffset();
        COLUMN_RECORD_NAME_SIZE_OFFSET = PartitionDecoder.columnRecordNameSizeOffset();
        COLUMN_RECORD_NAME_PTR_OFFSET = PartitionDecoder.columnRecordNamePtrOffset();
        ROW_GROUP_SIZES_PTR_OFFSET = PartitionDecoder.rowGroupSizesPtrOffset();
        ROW_GROUP_COUNT_OFFSET = PartitionDecoder.rowGroupCountOffset();
        COLUMN_IDS_OFFSET = PartitionDecoder.columnIdsOffset();
    }

    public class Metadata {
        private final ObjList<DirectString> columnNames = new ObjList();

        public int columnCount() {
            return Unsafe.getUnsafe().getInt(PartitionDecoder.this.ptr + COLUMN_COUNT_OFFSET);
        }

        public int columnId(int columnIndex) {
            return Unsafe.getUnsafe().getInt(PartitionDecoder.this.columnsPtr + (long)columnIndex * COLUMN_STRUCT_SIZE + COLUMN_IDS_OFFSET);
        }

        public CharSequence columnName(int columnIndex) {
            return this.columnNames.getQuick(columnIndex);
        }

        public void copyTo(GenericRecordMetadata metadata, boolean treatSymbolsAsVarchar) {
            metadata.clear();
            int columnCount = this.columnCount();
            for (int i = 0; i < columnCount; ++i) {
                String columnName = Chars.toString(this.columnName(i));
                int columnType = this.getColumnType(i);
                if (ColumnType.isSymbol(columnType)) {
                    if (treatSymbolsAsVarchar) {
                        metadata.add(new TableColumnMetadata(columnName, 26));
                        continue;
                    }
                    metadata.add(new TableColumnMetadata(columnName, columnType, false, 64, true, null));
                    continue;
                }
                metadata.add(new TableColumnMetadata(columnName, columnType));
            }
        }

        public int getColumnType(int columnIndex) {
            return Unsafe.getUnsafe().getInt(PartitionDecoder.this.columnsPtr + (long)columnIndex * COLUMN_STRUCT_SIZE + COLUMN_RECORD_TYPE_OFFSET);
        }

        public long rowCount() {
            return Unsafe.getUnsafe().getLong(PartitionDecoder.this.ptr + ROW_COUNT_OFFSET);
        }

        public int rowGroupCount() {
            return Unsafe.getUnsafe().getInt(PartitionDecoder.this.ptr + ROW_GROUP_COUNT_OFFSET);
        }

        public int rowGroupSize(int rowGroupIndex) {
            return Unsafe.getUnsafe().getInt(PartitionDecoder.this.rowGroupSizesPtr + 4L * (long)rowGroupIndex);
        }

        private void init() {
            this.columnNames.clear();
            PartitionDecoder.this.directStringPool.clear();
            long columnCount = this.columnCount();
            long currentColumnPtr = PartitionDecoder.this.columnsPtr;
            for (long i = 0L; i < columnCount; ++i) {
                DirectString str = PartitionDecoder.this.directStringPool.next();
                int len = Unsafe.getUnsafe().getInt(currentColumnPtr + COLUMN_RECORD_NAME_SIZE_OFFSET);
                long colNamePtr = Unsafe.getUnsafe().getLong(currentColumnPtr + COLUMN_RECORD_NAME_PTR_OFFSET);
                str.of(colNamePtr, len);
                this.columnNames.add(str);
                currentColumnPtr += COLUMN_STRUCT_SIZE;
            }
        }
    }
}

