/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8Sequence;

public class PartitionDescriptor
implements QuietCloseable,
Mutable {
    public static final int COLUMN_ADDR_OFFSET = 3;
    public static final int COLUMN_ENTRY_SIZE = 9;
    public static final int COLUMN_ID_AND_TYPE_OFFSET = 1;
    public static final int COLUMN_NAME_SIZE_OFFSET = 0;
    public static final int COLUMN_SECONDARY_ADDR_OFFSET = 5;
    public static final int COLUMN_SECONDARY_SIZE_OFFSET = 6;
    public static final int COLUMN_SIZE_OFFSET = 4;
    public static final int COLUMN_TOP_OFFSET = 2;
    public static final int SYMBOL_OFFSET_ADDR_OFFSET = 7;
    public static final int SYMBOL_OFFSET_SIZE_OFFSET = 8;
    protected DirectLongList columnData = new DirectLongList(64L, 19);
    protected DirectUtf8Sink columnNames = new DirectUtf8Sink(32L);
    protected long partitionRowCount;
    protected DirectUtf8Sink tableName = new DirectUtf8Sink(16L);
    protected int timestampIndex = -1;
    private long pendingEntryIndex = 0L;

    public void addColumn(CharSequence columnName, int columnType, int columnId, long columnTop, long columnAddr, long columnSize, long columnSecondaryAddr, long columnSecondarySize, long symbolOffsetsAddr, long symbolOffsetsSize) {
        int startSize = this.columnNames.size();
        this.columnNames.put(columnName);
        int columnNameSize = this.columnNames.size() - startSize;
        this.pendingEntryIndex = this.columnData.size();
        this.columnData.add(columnNameSize);
        this.columnData.add((long)columnId << 32 | (long)columnType);
        this.columnData.add(columnTop);
        this.columnData.add(columnAddr);
        this.columnData.add(columnSize);
        this.columnData.add(columnSecondaryAddr);
        this.columnData.add(columnSecondarySize);
        this.columnData.add(symbolOffsetsAddr);
        this.columnData.add(symbolOffsetsSize);
    }

    public void addColumn(CharSequence columnName, int columnType, int columnId, long columnTop) {
        int startSize = this.columnNames.size();
        this.columnNames.put(columnName);
        int columnNameSize = this.columnNames.size() - startSize;
        this.pendingEntryIndex = this.columnData.size();
        this.columnData.add(columnNameSize);
        this.columnData.add((long)columnId << 32 | (long)columnType);
        this.columnData.add(columnTop);
        this.columnData.add(0L);
        this.columnData.add(0L);
        this.columnData.add(0L);
        this.columnData.add(0L);
        this.columnData.add(0L);
        this.columnData.add(0L);
    }

    @Override
    public void clear() {
        this.pendingEntryIndex = 0L;
        this.tableName.clear();
        this.columnNames.clear();
        this.columnData.clear();
    }

    @Override
    public void close() {
        this.clear();
        this.tableName = Misc.free(this.tableName);
        this.columnNames = Misc.free(this.columnNames);
        this.columnData = Misc.free(this.columnData);
    }

    public int getColumnCount() {
        return (int)(this.getColumnDataLen() / 9L);
    }

    public long getColumnDataLen() {
        return this.columnData.size();
    }

    public long getColumnDataPtr() {
        return this.columnData.getAddress();
    }

    public int getColumnNamesLen() {
        return this.columnNames.size();
    }

    public long getColumnNamesPtr() {
        return this.columnNames.ptr();
    }

    public long getPartitionRowCount() {
        return this.partitionRowCount;
    }

    public Utf8Sequence getTableName() {
        return this.tableName;
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public PartitionDescriptor of(CharSequence tableName, long partitionRowCount, int timestampIndex) {
        this.clear();
        this.tableName.put(tableName);
        this.partitionRowCount = partitionRowCount;
        this.timestampIndex = timestampIndex;
        return this;
    }

    public void setColumnAddr(long columnAddr, long columnSize) {
        this.columnData.set(this.pendingEntryIndex + 3L, columnAddr);
        this.columnData.set(this.pendingEntryIndex + 4L, columnSize);
    }

    public void setSecondaryColumnAddr(long columnSecondaryAddr, long columnSecondarySize) {
        this.columnData.set(this.pendingEntryIndex + 5L, columnSecondaryAddr);
        this.columnData.set(this.pendingEntryIndex + 6L, columnSecondarySize);
    }

    public void setSymbolOffsetsAddr(long symbolOffsetsAddr, long symbolOffsetsSize) {
        this.columnData.set(this.pendingEntryIndex + 7L, symbolOffsetsAddr);
        this.columnData.set(this.pendingEntryIndex + 8L, symbolOffsetsSize);
    }
}

