/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.jit;

import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.SqlException;
import io.questdb.jit.FiltersCompiler;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class CompiledFilter
implements Closeable {
    private static final ThreadLocal<FiltersCompiler.JitError> tlJitError = new ThreadLocal<FiltersCompiler.JitError>(FiltersCompiler.JitError::new);
    private long fnAddress;

    public long call(long dataAddress, long dataSize, long varSizeAuxAddress, long varsAddress, long varsSize, long rowsAddress, long rowsSize, long rowsStartOffset) {
        return FiltersCompiler.callFunction(this.fnAddress, dataAddress, dataSize, varSizeAuxAddress, varsAddress, varsSize, rowsAddress, rowsSize, rowsStartOffset);
    }

    @Override
    public void close() {
        if (this.fnAddress > 0L) {
            FiltersCompiler.freeFunction(this.fnAddress);
            Unsafe.recordMemAlloc(-1L, 37);
            this.fnAddress = 0L;
        }
    }

    public void compile(MemoryCARW filter, int options) throws SqlException {
        long filterSize = filter.getAppendOffset();
        long filterAddress = filter.getPageAddress(0);
        FiltersCompiler.JitError error = tlJitError.get();
        error.reset();
        this.fnAddress = FiltersCompiler.compileFunction(filterAddress, filterSize, options, error);
        if (error.errorCode() != 0) {
            throw SqlException.position(0).put("JIT compilation failed [errorCode").put(error.errorCode()).put(", msg=").put(error.message()).put("]");
        }
        Unsafe.recordMemAlloc(1L, 37);
    }
}

