/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public final class SimpleWaitingLock {
    private final AtomicReference<Thread> ownerOrWaiter = new AtomicReference<Object>(null);

    public boolean isLocked() {
        return this.ownerOrWaiter.get() != null;
    }

    public void lock() {
        this.tryLock(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    public boolean tryLock(long timeout, TimeUnit unit) {
        Thread currentThread = Thread.currentThread();
        Thread expectedOwner = null;
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        long remainingNanos = deadline - System.nanoTime();
        while (remainingNanos > 0L) {
            if (this.ownerOrWaiter.compareAndSet(expectedOwner, currentThread)) {
                if (expectedOwner == null) {
                    return true;
                }
                LockSupport.parkNanos(remainingNanos);
            }
            expectedOwner = this.ownerOrWaiter.get();
            remainingNanos = deadline - System.nanoTime();
        }
        return false;
    }

    public boolean tryLock() {
        return this.ownerOrWaiter.compareAndSet(null, Thread.currentThread());
    }

    public void unlock() {
        Thread currentThread = Thread.currentThread();
        Thread waitingOrOwningThread = this.ownerOrWaiter.getAndSet(null);
        if (waitingOrOwningThread == null) {
            throw new IllegalStateException("Lock is not owned");
        }
        if (waitingOrOwningThread == currentThread) {
            return;
        }
        LockSupport.unpark(waitingOrOwningThread);
    }
}

