/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class IntStack
implements Mutable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final int NO_ENTRY_VALUE = -1;
    private int bottom;
    private int[] elements;
    private int head;
    private int mask;
    private int tail;

    public IntStack() {
        this(16);
    }

    public IntStack(int initialCapacity) {
        this.allocateElements(initialCapacity);
    }

    public int bottom() {
        return this.bottom;
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            this.tail = 0;
            this.head = 0;
            Arrays.fill(this.elements, -1);
            this.bottom = 0;
        }
    }

    public boolean notEmpty() {
        return this.size() > 0;
    }

    public int peek() {
        return this.peek(0);
    }

    public int peek(int n) {
        return n < this.size() ? this.elements[this.head + n & this.mask] : -1;
    }

    public int pollLast() {
        if (this.bottom != 0) {
            throw new IllegalStateException("pollLast() called while bottom != 0");
        }
        int[] elems = this.elements;
        int newTail = this.tail;
        if (this.head != newTail && --newTail < 0) {
            newTail = this.mask;
        }
        int elem = elems[newTail];
        this.tail = newTail;
        elems[newTail] = -1;
        return elem;
    }

    public int pop() {
        if (this.size() == 0) {
            return -1;
        }
        int h = this.head;
        int result = this.elements[h];
        if (result == -1) {
            return -1;
        }
        this.elements[h] = -1;
        this.head = h + 1 & this.mask;
        return result;
    }

    public void popAll() {
        int h = this.head;
        while ((this.tail - h & this.mask) > this.bottom) {
            this.elements[h] = -1;
            h = h + 1 & this.mask;
        }
        this.head = h;
    }

    public void push(int e) {
        this.head = this.head - 1 & this.mask;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void setBottom(int bottom) {
        if (bottom > this.sizeRaw()) {
            throw new IllegalStateException("Tried to set bottom beyond the top of the stack");
        }
        this.bottom = bottom;
    }

    public int size() {
        return this.sizeRaw() - this.bottom;
    }

    public int sizeRaw() {
        return this.tail - this.head & this.mask;
    }

    public void update(int e) {
        this.elements[this.head] = e;
    }

    private void allocateElements(int capacity) {
        capacity = capacity < 8 ? 8 : Numbers.ceilPow2(capacity);
        this.elements = new int[capacity];
        this.mask = capacity - 1;
        Arrays.fill(this.elements, -1);
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int h = this.head;
        int n = this.elements.length;
        int r = n - h;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Stack is too big");
        }
        int[] next = new int[newCapacity];
        System.arraycopy(this.elements, h, next, 0, r);
        System.arraycopy(this.elements, 0, next, r, h);
        Arrays.fill(next, r + h, newCapacity, -1);
        this.elements = next;
        this.head = 0;
        this.tail = n;
        this.mask = newCapacity - 1;
    }
}

