/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.ColumnTypes;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;

public final class Rosti {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alloc(ColumnTypes types, long capacity) {
        assert (capacity >= 16L);
        int columnCount = types.getColumnCount();
        long mem = Unsafe.malloc(4L * (long)columnCount, 52);
        try {
            long p = mem;
            for (int i = 0; i < columnCount; ++i) {
                Unsafe.getUnsafe().putInt(p, types.getColumnType(i));
                p += 4L;
            }
            long pRosti = Rosti.alloc(mem, columnCount, Numbers.ceilPow2(capacity) - 1L);
            if (pRosti != 0L) {
                Unsafe.recordMemAlloc(Rosti.getAllocMemory(pRosti), 52);
            }
            long l = pRosti;
            return l;
        }
        finally {
            Unsafe.free(mem, 4L * (long)columnCount, 52);
        }
    }

    public static native void clear(long var0);

    public static native void disableOOMOnMalloc();

    public static native void enableOOMOnMalloc();

    public static void free(long pRosti) {
        long size = Rosti.getAllocMemory(pRosti);
        Rosti.free0(pRosti);
        Unsafe.recordMemAlloc(-size, 52);
    }

    public static native long getAllocMemory(long var0);

    public static long getCapacity(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 24L);
    }

    public static long getCtrl(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti);
    }

    public static long getInitialValueSlot(long pRosti, int columnIndex) {
        return Rosti.getInitialValuesSlot(pRosti) + (long)Unsafe.getUnsafe().getInt(Rosti.getValueOffsets(pRosti) + (long)columnIndex * 4L);
    }

    public static long getInitialValuesSlot(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 64L);
    }

    public static long getSize(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 16L);
    }

    public static long getSlotShift(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 40L);
    }

    public static long getSlotSize(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 32L);
    }

    public static long getSlots(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 8L);
    }

    public static long getValueOffsets(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 56L);
    }

    public static native boolean keyedHourCount(long var0, long var2, long var4, int var6);

    public static native boolean keyedHourCountDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourCountInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourCountLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourDistinct(long var0, long var2, long var4);

    public static native boolean keyedHourKSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMaxDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMaxInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMaxLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMaxShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMinDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMinInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMinLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourMinShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourNSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumLong256(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumLongLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedHourSumShortLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntAvgDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native boolean keyedIntAvgLongLongWrapUp(long var0, int var2, double var3, long var5);

    public static native boolean keyedIntAvgLongWrapUp(long var0, int var2, double var3, long var5);

    public static native boolean keyedIntCount(long var0, long var2, long var4, int var6);

    public static native boolean keyedIntCountDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntCountInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntCountLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntCountMerge(long var0, long var2, int var4);

    public static native boolean keyedIntCountWrapUp(long var0, int var2, long var3);

    public static native boolean keyedIntDistinct(long var0, long var2, long var4);

    public static native boolean keyedIntKSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntKSumDoubleMerge(long var0, long var2, int var4);

    public static native boolean keyedIntKSumDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native boolean keyedIntMaxDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMaxDoubleMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMaxDoubleWrapUp(long var0, int var2, double var3);

    public static native boolean keyedIntMaxInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMaxIntMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMaxIntWrapUp(long var0, int var2, int var3);

    public static native boolean keyedIntMaxLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMaxLongMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMaxLongWrapUp(long var0, int var2, long var3);

    public static native boolean keyedIntMaxShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMaxShortWrapUp(long var0, int var2, int var3);

    public static native boolean keyedIntMinDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMinDoubleMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMinDoubleWrapUp(long var0, int var2, double var3);

    public static native boolean keyedIntMinInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMinIntMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMinIntWrapUp(long var0, int var2, int var3);

    public static native boolean keyedIntMinLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMinLongMerge(long var0, long var2, int var4);

    public static native boolean keyedIntMinLongWrapUp(long var0, int var2, long var3);

    public static native boolean keyedIntMinShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntMinShortWrapUp(long var0, int var2, long var3);

    public static native boolean keyedIntNSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntNSumDoubleMerge(long var0, long var2, int var4);

    public static native boolean keyedIntNSumDoubleWrapUp(long var0, int var2, double var3, long var5, double var7);

    public static native boolean keyedIntSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumDoubleMerge(long var0, long var2, int var4);

    public static native boolean keyedIntSumDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native boolean keyedIntSumInt(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumIntMerge(long var0, long var2, int var4);

    public static native boolean keyedIntSumLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumLong256(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumLong256Merge(long var0, long var2, int var4);

    public static native boolean keyedIntSumLong256WrapUp(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    public static native boolean keyedIntSumLongLong(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumLongLongMerge(long var0, long var2, int var4);

    public static native boolean keyedIntSumLongMerge(long var0, long var2, int var4);

    public static native boolean keyedIntSumLongWrapUp(long var0, int var2, long var3, long var5);

    public static native boolean keyedIntSumShort(long var0, long var2, long var4, long var6, int var8);

    public static native boolean keyedIntSumShortLong(long var0, long var2, long var4, long var6, int var8);

    public static void printRosti(long pRosti) {
        long ctrl;
        long slots = Rosti.getSlots(pRosti);
        long shift = Rosti.getSlotShift(pRosti);
        long start = ctrl = Rosti.getCtrl(pRosti);
        long count = Rosti.getSize(pRosti);
        System.out.println("size=" + count);
        System.out.println("capacity=" + Rosti.getCapacity(pRosti));
        System.out.println("slot size=" + Rosti.getSlotSize(pRosti));
        System.out.println("slot shift=" + Rosti.getSlotShift(pRosti));
        System.out.print("initial slot=");
        long initialSlot = Rosti.getInitialValuesSlot(pRosti);
        long n = Rosti.getSlotSize(pRosti);
        for (long i = 0L; i < n; ++i) {
            int b = Unsafe.getUnsafe().getByte(initialSlot + i);
            int v = b < 0 ? 256 + b : b;
            if (v < 16) {
                System.out.print('0');
                System.out.print(Numbers.hexDigits[b]);
            } else {
                System.out.print(Numbers.hexDigits[v / 16]);
                System.out.print(Numbers.hexDigits[v % 16]);
            }
            System.out.print(' ');
        }
        System.out.println();
        while (count > 0L) {
            byte b = Unsafe.getUnsafe().getByte(ctrl);
            if ((b & 0x80) == 0) {
                long p = slots + (ctrl - start << (int)shift);
                System.out.println(Unsafe.getUnsafe().getInt(p) + " -> " + Unsafe.getUnsafe().getDouble(p + 12L));
                --count;
            }
            ++ctrl;
        }
    }

    public static boolean reset(long pRosti, int size) {
        long oldSize = Rosti.getAllocMemory(pRosti);
        boolean success = Rosti.reset0(pRosti, Numbers.ceilPow2(size) - 1);
        Rosti.updateMemoryUsage(pRosti, oldSize);
        return success;
    }

    public static void updateMemoryUsage(long pRosti, long oldSize) {
        long newSize = Rosti.getAllocMemory(pRosti);
        Unsafe.recordMemAlloc(newSize - oldSize, 52);
    }

    private static native long alloc(long var0, int var2, long var3);

    private static native void free0(long var0);

    private static native boolean reset0(long var0, int var2);
}

