/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class SimpleReadWriteLock
implements ReadWriteLock {
    private final int MAX_READERS = 0x3FFFFFFE;
    private final AtomicBoolean lock = new AtomicBoolean();
    private final AtomicInteger nReaders = new AtomicInteger();
    private final ReadLock readLock = new ReadLock();
    private final WriteLock writeLock = new WriteLock();

    public boolean isWriteLocked() {
        return this.lock.get();
    }

    @Override
    @NotNull
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    @NotNull
    public Lock writeLock() {
        return this.writeLock;
    }

    private class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            while (SimpleReadWriteLock.this.nReaders.incrementAndGet() >= 0x3FFFFFFE) {
                SimpleReadWriteLock.this.nReaders.decrementAndGet();
                Thread.yield();
            }
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            SimpleReadWriteLock.this.nReaders.decrementAndGet();
        }
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            while (!SimpleReadWriteLock.this.lock.compareAndSet(false, true)) {
                Thread.yield();
            }
            int n = SimpleReadWriteLock.this.nReaders.addAndGet(0x3FFFFFFE);
            while (n != 0x3FFFFFFE) {
                n = SimpleReadWriteLock.this.nReaders.get();
            }
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            if (!SimpleReadWriteLock.this.lock.compareAndSet(false, true)) {
                return false;
            }
            int n = SimpleReadWriteLock.this.nReaders.addAndGet(0x3FFFFFFE);
            if (n == 0x3FFFFFFE) {
                return true;
            }
            SimpleReadWriteLock.this.nReaders.addAndGet(-1073741822);
            SimpleReadWriteLock.this.lock.set(false);
            return false;
        }

        @Override
        public void unlock() {
            SimpleReadWriteLock.this.nReaders.addAndGet(-1073741822);
            SimpleReadWriteLock.this.lock.set(false);
        }
    }
}

