/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public final class Uuid
implements Sinkable {
    public static final int FIRST_DASH_POS = 8;
    public static final int FOURTH_DASH_POS = 23;
    public static final int SECOND_DASH_POS = 13;
    public static final int THIRD_DASH_POS = 18;
    public static final int UUID_LENGTH = 36;
    private long hi = Long.MIN_VALUE;
    private long lo = Long.MIN_VALUE;

    public Uuid(long lo, long hi) {
        this.of(lo, hi);
    }

    public Uuid() {
    }

    public static void checkDashesAndLength(CharSequence uuid) throws NumericException {
        Uuid.checkDashesAndLength(uuid, 0, uuid.length());
    }

    public static void checkDashesAndLength(CharSequence uuid, int lo, int hi) throws NumericException {
        if (lo < 0 || hi < lo || hi > uuid.length()) {
            throw NumericException.INSTANCE;
        }
        if (hi - lo != 36) {
            throw NumericException.INSTANCE;
        }
        if (uuid.charAt(lo + 8) != '-' || uuid.charAt(lo + 13) != '-' || uuid.charAt(lo + 18) != '-' || uuid.charAt(lo + 23) != '-') {
            throw NumericException.INSTANCE;
        }
    }

    public static void checkDashesAndLength(Utf8Sequence uuid) throws NumericException {
        if (uuid.size() != 36) {
            throw NumericException.INSTANCE;
        }
        if (uuid.byteAt(8) != 45 || uuid.byteAt(13) != 45 || uuid.byteAt(18) != 45 || uuid.byteAt(23) != 45) {
            throw NumericException.INSTANCE;
        }
    }

    public static int compare(long aLo, long bHi, long aHi, long bLo) {
        if (Uuid.isNull(aLo, aHi)) {
            return Uuid.isNull(bLo, bHi) ? 0 : -1;
        }
        if (Uuid.isNull(bLo, bHi)) {
            return 1;
        }
        int compHi = Long.compareUnsigned(aHi, bHi);
        if (compHi != 0) {
            return compHi;
        }
        return Long.compareUnsigned(aLo, bLo);
    }

    public static boolean isNull(long lo, long hi) {
        return hi == Long.MIN_VALUE && lo == Long.MIN_VALUE;
    }

    public static long parseHi(CharSequence uuid) throws NumericException {
        return Uuid.parseHi(uuid, 0);
    }

    public static long parseHi(CharSequence uuid, int lo) throws NumericException {
        assert (lo >= 0);
        long hi1 = Numbers.parseHexLong(uuid, lo, lo + 8);
        long hi2 = Numbers.parseHexLong(uuid, lo + 8 + 1, lo + 13);
        long hi3 = Numbers.parseHexLong(uuid, lo + 13 + 1, lo + 18);
        return hi1 << 32 | hi2 << 16 | hi3;
    }

    public static long parseHi(Utf8Sequence uuid, int lo) throws NumericException {
        assert (lo >= 0);
        long hi1 = Numbers.parseHexLong(uuid, lo, lo + 8);
        long hi2 = Numbers.parseHexLong(uuid, lo + 8 + 1, lo + 13);
        long hi3 = Numbers.parseHexLong(uuid, lo + 13 + 1, lo + 18);
        return hi1 << 32 | hi2 << 16 | hi3;
    }

    public static long parseLo(CharSequence uuid) throws NumericException {
        return Uuid.parseLo(uuid, 0);
    }

    public static long parseLo(CharSequence uuid, int lo) throws NumericException {
        assert (lo >= 0);
        long lo1 = Numbers.parseHexLong(uuid, lo + 18 + 1, lo + 23);
        long lo2 = Numbers.parseHexLong(uuid, lo + 23 + 1, lo + 36);
        return lo1 << 48 | lo2;
    }

    public static long parseLo(Utf8Sequence uuid, int lo) throws NumericException {
        assert (lo >= 0);
        long lo1 = Numbers.parseHexLong(uuid, lo + 18 + 1, lo + 23);
        long lo2 = Numbers.parseHexLong(uuid, lo + 23 + 1, lo + 36);
        return lo1 << 48 | lo2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != Uuid.class) {
            return false;
        }
        Uuid that = (Uuid)o;
        return this.lo == that.lo && this.hi == that.hi;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public int hashCode() {
        return Hash.hashLong128_32(this.lo, this.hi);
    }

    public void of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public void of(@NotNull CharSequence uuid) throws NumericException {
        Uuid.checkDashesAndLength(uuid);
        this.lo = Uuid.parseLo(uuid);
        this.hi = Uuid.parseHi(uuid);
    }

    public void of(@NotNull Utf8Sequence uuid) throws NumericException {
        CharSequence csView = uuid.asAsciiCharSequence();
        Uuid.checkDashesAndLength(csView);
        this.lo = Uuid.parseLo(csView);
        this.hi = Uuid.parseHi(csView);
    }

    public void of(@NotNull CharSequence uuid, int lo, int hi) throws NumericException {
        Uuid.checkDashesAndLength(uuid, lo, hi);
        this.lo = Uuid.parseLo(uuid, lo);
        this.hi = Uuid.parseHi(uuid, lo);
    }

    public void ofNull() {
        this.lo = Long.MIN_VALUE;
        this.hi = Long.MIN_VALUE;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        Numbers.appendUuid(this.lo, this.hi, sink);
    }
}

