/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.mp.ValueHolder;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ValueHolderList<T extends ValueHolder<T>> {
    private final ObjectFactory<T> factory;
    private final ObjList<T> storage;
    private int size;

    public ValueHolderList(ObjectFactory<T> factory, int initialCapacity) {
        this.factory = factory;
        this.storage = new ObjList(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            this.storage.add((ValueHolder)factory.newInstance());
        }
    }

    public void clear() {
        this.size = 0;
    }

    public void commitNextHolder() {
        assert (this.size < this.storage.size());
        ++this.size;
    }

    public void moveQuick(int i, @NotNull T dest) {
        assert (i >= 0 && i < this.size);
        ValueHolder item = (ValueHolder)this.storage.getQuick(i);
        item.copyTo(dest);
        item.clear();
    }

    @NotNull
    public T peekNextHolder() {
        ValueHolder holder;
        if (this.size < this.storage.size()) {
            holder = (ValueHolder)this.storage.getQuick(this.size);
        } else {
            holder = (ValueHolder)this.factory.newInstance();
            this.storage.add(holder);
        }
        return (T)holder;
    }

    public int size() {
        return this.size;
    }
}

