/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.bytes;

public class Bytes {
    private Bytes() {
    }

    public static long align2b(long size) {
        return size + 1L & 0xFFFFFFFFFFFFFFFEL;
    }

    public static long align4b(long size) {
        return size + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public static long align8b(long size) {
        return size + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    public static int checkedLoHiSize(long lo, long hi, int baseSize) {
        long additional = hi - lo;
        if (additional < 0L) {
            throw new IllegalArgumentException("lo > hi");
        }
        long size = (long)baseSize + additional;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size exceeds 2GiB limit");
        }
        return (int)additional;
    }
}

