/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;

public class DmdbIntervalYM
implements Serializable {
    private static final long serialVersionUID = 1952079341353118308L;
    public static final byte QUA_Y = 0;
    public static final byte QUA_YM = 1;
    public static final byte QUA_MO = 2;
    private int leadScale = 0;
    private boolean isLeadScaleSet = false;
    public byte type = 0;
    public int years = 0;
    public int months = 0;
    private int scaleForSvr = 0;

    private DmdbIntervalYM(byte by, int n2, int n3, int n4) {
        this.type = by;
        this.years = n2;
        this.months = n3;
        this.scaleForSvr = n4;
        this.leadScale = n4 >> 4 & 0xF;
    }

    public DmdbIntervalYM(String string) {
        this.isLeadScaleSet = false;
        this.parseIntervYMString(string);
    }

    public DmdbIntervalYM(byte[] byArray) {
        this.reset(byArray);
    }

    private void reset(byte[] byArray) {
        this.scaleForSvr = ByteUtil.getInt(byArray, 8);
        this.leadScale = this.scaleForSvr >> 4 & 0xF;
        this.type = byArray[9];
        switch (this.type) {
            case 0: {
                this.years = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 1: {
                this.years = ByteUtil.getInt(byArray, 0);
                this.months = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 2: {
                this.months = ByteUtil.getInt(byArray, 4);
            }
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DmdbIntervalYM) {
            DmdbIntervalYM dmdbIntervalYM = (DmdbIntervalYM)object;
            if (dmdbIntervalYM.type == this.type) {
                switch (this.type) {
                    case 0: {
                        if (this.years != dmdbIntervalYM.years) break;
                        return true;
                    }
                    case 1: {
                        if (this.years != dmdbIntervalYM.years || this.months != dmdbIntervalYM.months) break;
                        return true;
                    }
                    case 2: {
                        if (this.months != dmdbIntervalYM.months) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final int getYear() {
        return this.years;
    }

    public final int getMonth() {
        return this.months;
    }

    public final byte getYMType() {
        return this.type;
    }

    public final int getLeadScale() {
        return this.leadScale;
    }

    public final String toString() {
        String string = "INTERVAL ";
        switch (this.type) {
            case 0: {
                String string2 = String.valueOf(Math.abs(this.years));
                if (this.years < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.leadScale > string2.length()) {
                    int n2 = string2.length();
                    int n3 = this.leadScale;
                    while (n3-- > n2) {
                        string2 = "0" + string2;
                    }
                }
                string = String.valueOf(string) + "'" + string2 + "' YEAR(" + this.leadScale + ")";
                break;
            }
            case 1: {
                String string3 = String.valueOf(Math.abs(this.years));
                String string4 = String.valueOf(Math.abs(this.months));
                if (this.years < 0 || this.months < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.leadScale > string3.length()) {
                    int n4 = string3.length();
                    int n5 = this.leadScale;
                    while (n5-- > n4) {
                        string3 = "0" + string3;
                    }
                }
                if (string4.length() < 2) {
                    string4 = "0" + string4;
                }
                string = String.valueOf(string) + "'" + string3 + "-" + string4 + "' YEAR(" + this.leadScale + ") TO MONTH";
                break;
            }
            case 2: {
                String string5 = String.valueOf(Math.abs(this.months));
                if (this.months < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.leadScale > string5.length()) {
                    int n6 = string5.length();
                    int n7 = this.leadScale;
                    while (n7-- > n6) {
                        string5 = "0" + string5;
                    }
                }
                string = String.valueOf(string) + "'" + string5 + "' MONTH(" + this.leadScale + ")";
            }
        }
        return string;
    }

    public byte[] encode(int n2) {
        Object object;
        if (n2 == 0) {
            n2 = this.scaleForSvr;
        }
        int n3 = this.years;
        int n4 = this.months;
        this.checkScale(this.leadScale);
        if (n2 != this.scaleForSvr) {
            object = this.convertTo(n2);
            n3 = ((DmdbIntervalYM)object).years;
            n4 = ((DmdbIntervalYM)object).months;
        } else {
            this.checkScale(this.leadScale);
        }
        object = new byte[12];
        ByteUtil.setInt((byte[])object, 0, n3);
        ByteUtil.setInt((byte[])object, 4, n4);
        ByteUtil.setInt((byte[])object, 8, n2);
        return object;
    }

    public DmdbIntervalYM convertTo(int n2) {
        int n3 = (n2 & 0xFF00) >> 8;
        int n4 = n2 >> 4 & 0xF;
        long l2 = this.years * 12 + this.months;
        long l3 = 0L;
        long l4 = 0L;
        switch (n3) {
            case 0: {
                l3 = l2 / 12L;
                if (l2 % 12L >= 6L) {
                    ++l3;
                } else if (l2 % 12L <= -6L) {
                    --l3;
                }
                if (n4 >= String.valueOf(Math.abs(l3)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 1: {
                l3 = this.years;
                l4 = this.months;
                if (n4 >= String.valueOf(Math.abs(l3)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 2: {
                l4 = l2;
                if (n4 >= String.valueOf(Math.abs(l4)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
            }
        }
        return new DmdbIntervalYM((byte)n3, (int)l3, (int)l4, n2);
    }

    private int getLeadPrec(String string, int n2) {
        if (this.isLeadScaleSet) {
            return this.leadScale;
        }
        int n3 = string.indexOf("(", n2);
        int n4 = string.indexOf(")", n2);
        int n5 = 0;
        if (n4 == -1 && n3 == -1) {
            String string2;
            int n6 = string.indexOf("'");
            int n7 = n6 != -1 ? string.indexOf("'", n6 + 1) : -1;
            String string3 = string2 = n7 != -1 ? string.substring(n6 + 1, n7).trim() : null;
            if (StringUtil.isNotEmpty(string2)) {
                int n8;
                char c2 = string2.charAt(0);
                if (c2 == '+' || c2 == '-') {
                    string2 = string2.substring(1).trim();
                }
                string2 = (n8 = string2.indexOf("-")) != -1 ? string2.substring(0, n8) : string2;
                n5 = string2.length();
            } else {
                n5 = 2;
            }
        } else if (n4 != -1 && n3 != -1 && n4 > n3 + 1) {
            String string4 = string.substring(n3 + 1, n4).trim();
            n5 = Integer.parseInt(string4);
        } else {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        return n5;
    }

    private int[] getTimeValue(String string, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            bl = true;
            string = string.substring(1, string.length() - 1).trim();
        }
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            string = string.substring(1);
        } else if (string.startsWith("+")) {
            bl2 = false;
            string = string.substring(1);
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            bl = true;
            string = string.substring(1, string.length() - 1).trim();
        }
        if (!bl) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        int n5 = string.lastIndexOf("-");
        String[] stringArray = new String[2];
        if (n5 == -1 || n5 == 0) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n5);
            stringArray[1] = string.substring(n5 + 1);
        }
        if (n2 == 1) {
            n4 = Integer.parseInt(stringArray[0]);
            n3 = stringArray[1].equalsIgnoreCase("") ? 0 : Integer.parseInt(stringArray[1]);
            if (bl2) {
                n4 *= -1;
                n3 *= -1;
            }
            if ((double)n4 > Math.pow(10.0, this.leadScale) - 1.0 || (double)n4 < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else if (n2 == 0) {
            n4 = Integer.parseInt(stringArray[0]);
            n3 = 0;
            if (bl2) {
                n4 *= -1;
            }
            if ((double)n4 > Math.pow(10.0, this.leadScale) - 1.0 || (double)n4 < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else {
            n4 = 0;
            n3 = Integer.parseInt(stringArray[0]);
            if (bl2) {
                n3 *= -1;
            }
            if ((double)n3 > Math.pow(10.0, this.leadScale) - 1.0 || (double)n3 < 1.0 - Math.pow(10.0, this.leadScale)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        }
        int[] nArray = new int[]{n4, n3};
        return nArray;
    }

    private void parseIntervYMString(String string) {
        String[] stringArray;
        int n2;
        if (string == null) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        if ((n2 = (stringArray = (string = string.toUpperCase()).split(" ")).length) < 3 || !stringArray[0].equalsIgnoreCase("INTERVAL") || !stringArray[2].startsWith("YEAR") && !stringArray[2].startsWith("MONTH")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = 1;
        int n3 = string.indexOf("YEAR");
        int n4 = string.indexOf("MONTH");
        int n5 = string.indexOf("TO");
        if (n5 == -1) {
            if (n3 != -1 && n4 == -1) {
                this.type = 0;
                this.leadScale = this.getLeadPrec(string, n3);
            } else if (n4 != -1 && n3 == -1) {
                this.type = (byte)2;
                this.leadScale = this.getLeadPrec(string, n4);
            } else {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        } else {
            if (n3 == -1 || n4 == -1) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
            this.type = 1;
            this.leadScale = this.getLeadPrec(string, n3);
        }
        this.scaleForSvr = (this.type << 8) + (this.leadScale << 4);
        int[] nArray = this.getTimeValue(stringArray[1], this.type);
        this.years = nArray[0];
        this.months = nArray[1];
        this.checkScale(this.leadScale);
    }

    private void checkScale(int n2) {
        switch (this.type) {
            case 0: {
                if (n2 >= String.valueOf(Math.abs(this.years)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 1: {
                if (n2 < String.valueOf(Math.abs(this.years)).length()) {
                    DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                }
                if (Math.abs(this.months) <= 11) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 2: {
                if (n2 >= String.valueOf(Math.abs(this.months)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
            }
        }
    }

    public int getScaleForSvr() {
        return this.scaleForSvr;
    }
}

