/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.common.ssh;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.collector.collect.common.cache.AbstractConnection;
import org.apache.hertzbeat.collector.collect.common.cache.CacheIdentifier;
import org.apache.hertzbeat.collector.collect.common.cache.GlobalConnectionCache;
import org.apache.hertzbeat.collector.collect.common.cache.SshConnect;
import org.apache.hertzbeat.collector.collect.common.ssh.CommonSshClient;
import org.apache.hertzbeat.collector.util.PrivateKeyUtils;
import org.apache.hertzbeat.common.entity.job.protocol.SshProtocol;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SshHelper {
    private static final Logger log = LoggerFactory.getLogger(SshHelper.class);
    private static final GlobalConnectionCache CONNECTION_COMMON_CACHE = GlobalConnectionCache.getInstance();

    public static ClientSession getConnectSession(String host, String port, String username, String password, String privateKey, String privateKeyPassphrase, int timeout, boolean reuseConnection) throws IOException, GeneralSecurityException {
        SshConnect sshConnect;
        CacheIdentifier identifier = CacheIdentifier.builder().ip(host).port(port).username(username).password(password).build();
        ClientSession clientSession = null;
        if (reuseConnection) {
            Optional<AbstractConnection<?>> cacheOption = CONNECTION_COMMON_CACHE.getCache(identifier, true);
            if (cacheOption.isPresent()) {
                sshConnect = (SshConnect)cacheOption.get();
                clientSession = sshConnect.getConnection();
                try {
                    if (clientSession == null || clientSession.isClosed() || clientSession.isClosing()) {
                        clientSession = null;
                        CONNECTION_COMMON_CACHE.removeCache(identifier);
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                    clientSession = null;
                    CONNECTION_COMMON_CACHE.removeCache(identifier);
                }
            }
            if (clientSession != null) {
                return clientSession;
            }
        }
        SshClient sshClient = CommonSshClient.getSshClient();
        clientSession = (ClientSession)((ConnectFuture)sshClient.connect(username, host, Integer.parseInt(port)).verify((long)timeout, TimeUnit.MILLISECONDS)).getSession();
        if (StringUtils.hasText((String)password)) {
            clientSession.addPasswordIdentity(password);
        } else if (StringUtils.hasText((String)privateKey)) {
            String resourceKey = PrivateKeyUtils.writePrivateKey(host, privateKey);
            FilePasswordProvider passwordProvider = (session, resource, index) -> {
                if (StringUtils.hasText((String)privateKeyPassphrase)) {
                    return privateKeyPassphrase;
                }
                return null;
            };
            SecurityUtils.loadKeyPairIdentities(null, () -> resourceKey, (InputStream)new FileInputStream(resourceKey), (FilePasswordProvider)passwordProvider).forEach(arg_0 -> ((ClientSession)clientSession).addPublicKeyIdentity(arg_0));
        }
        if (!((AuthFuture)clientSession.auth().verify((long)timeout, TimeUnit.MILLISECONDS)).isSuccess()) {
            clientSession.close();
            throw new IllegalArgumentException("ssh auth failed.");
        }
        if (reuseConnection) {
            sshConnect = new SshConnect(clientSession);
            CONNECTION_COMMON_CACHE.addCache(identifier, sshConnect);
        }
        return clientSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientSession getConnectSession(SshProtocol sshProtocol, int timeout, boolean reuseConnection, boolean useProxy) throws IOException, GeneralSecurityException {
        CacheIdentifier identifier = CacheIdentifier.builder().ip(sshProtocol.getHost()).port(sshProtocol.getPort()).username(sshProtocol.getUsername()).password(sshProtocol.getPassword()).build();
        ClientSession clientSession = null;
        if (reuseConnection || useProxy) {
            Optional<AbstractConnection<?>> cacheOption = CONNECTION_COMMON_CACHE.getCache(identifier, true);
            if (cacheOption.isPresent()) {
                SshConnect sshConnect = (SshConnect)cacheOption.get();
                clientSession = sshConnect.getConnection();
                try {
                    if (clientSession == null || clientSession.isClosed() || clientSession.isClosing()) {
                        clientSession = null;
                        CONNECTION_COMMON_CACHE.removeCache(identifier);
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                    clientSession = null;
                    CONNECTION_COMMON_CACHE.removeCache(identifier);
                }
            }
            if (clientSession != null) {
                return clientSession;
            }
        }
        SshClient sshClient = CommonSshClient.getSshClient();
        HostConfigEntry proxyConfig = new HostConfigEntry();
        if (useProxy && StringUtils.hasText((String)sshProtocol.getProxyHost())) {
            String proxySpec = String.format("%s@%s:%d", sshProtocol.getProxyUsername(), sshProtocol.getProxyHost(), Integer.parseInt(sshProtocol.getProxyPort()));
            proxyConfig.setHostName(sshProtocol.getHost());
            proxyConfig.setHost(sshProtocol.getHost());
            proxyConfig.setPort(Integer.parseInt(sshProtocol.getPort()));
            proxyConfig.setUsername(sshProtocol.getUsername());
            proxyConfig.setProxyJump(proxySpec);
            if (StringUtils.hasText((String)sshProtocol.getProxyPassword())) {
                sshClient.addPasswordIdentity(sshProtocol.getProxyPassword());
                log.debug("Loaded proxy server password authentication: {}@{}", (Object)sshProtocol.getProxyUsername(), (Object)sshProtocol.getProxyHost());
            }
            if (StringUtils.hasText((String)sshProtocol.getProxyPrivateKey())) {
                proxyConfig.setIdentities(List.of(sshProtocol.getProxyPrivateKey()));
                log.debug("Proxy private key loaded into HostConfigEntry");
            }
        }
        if (useProxy && StringUtils.hasText((String)sshProtocol.getProxyHost())) {
            try {
                clientSession = (ClientSession)((ConnectFuture)sshClient.connect(proxyConfig).verify((long)timeout, TimeUnit.MILLISECONDS)).getSession();
            }
            finally {
                sshClient.removePasswordIdentity(sshProtocol.getProxyPassword());
            }
        } else {
            clientSession = (ClientSession)((ConnectFuture)sshClient.connect(sshProtocol.getUsername(), sshProtocol.getHost(), Integer.parseInt(sshProtocol.getPort())).verify((long)timeout, TimeUnit.MILLISECONDS)).getSession();
        }
        if (StringUtils.hasText((String)sshProtocol.getPassword())) {
            clientSession.addPasswordIdentity(sshProtocol.getPassword());
        } else if (StringUtils.hasText((String)sshProtocol.getPrivateKey())) {
            String resourceKey = PrivateKeyUtils.writePrivateKey(sshProtocol.getHost(), sshProtocol.getPrivateKey());
            try (FileInputStream keyStream = new FileInputStream(resourceKey);){
                FilePasswordProvider passwordProvider = (session, resource, index) -> {
                    if (StringUtils.hasText((String)sshProtocol.getPrivateKeyPassphrase())) {
                        return sshProtocol.getPrivateKeyPassphrase();
                    }
                    return null;
                };
                Iterable keyPairs = SecurityUtils.loadKeyPairIdentities(null, () -> resourceKey, (InputStream)keyStream, (FilePasswordProvider)passwordProvider);
                if (keyPairs != null) {
                    keyPairs.forEach(arg_0 -> ((ClientSession)clientSession).addPublicKeyIdentity(arg_0));
                } else {
                    log.error("Failed to load private key pairs from: {}", (Object)resourceKey);
                }
            }
            catch (IOException e) {
                log.error("Error reading private key file: {}", (Object)e.getMessage());
            }
        }
        if (!((AuthFuture)clientSession.auth().verify((long)timeout, TimeUnit.MILLISECONDS)).isSuccess()) {
            clientSession.close();
            throw new IllegalArgumentException("ssh auth failed.");
        }
        if (reuseConnection || useProxy) {
            SshConnect sshConnect = new SshConnect(clientSession);
            CONNECTION_COMMON_CACHE.addCache(identifier, sshConnect);
        }
        return clientSession;
    }
}

