/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.ConnectionIO;
import com.xugu.cloudjdbc.LogWriter;
import com.xugu.cloudjdbc.SlowSQLBean;
import java.text.SimpleDateFormat;
import java.util.Date;

class Command {
    public static boolean debug = false;
    static String debugLevel = "normalRecvTurn,CheckConnectionIsValid,CheckPrepareSqlAndParameter";

    Command() {
    }

    static void logHandshake(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("beginHandshake") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.beginHandshake);
        }
    }

    static void logConnectError(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("connectError") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.connectError);
        }
    }

    static void logBlockedState(ConnectionIO comIO, String logStr, boolean blockState) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("blockState") != -1) {
            comIO.lw.write(comIO.sessionId, logStr + "," + blockState, LogWriter.CmdState.blockState);
        }
    }

    static void logStmOverState(ConnectionIO comIO, String logStr, boolean stmOverState) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("stOverState") != -1) {
            comIO.lw.write(comIO.sessionId, logStr + "," + stmOverState, LogWriter.CmdState.stOverState);
        }
    }

    static void logRsOverState(ConnectionIO comIO, String logStr, boolean rsOverState) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("rsOverState") != -1) {
            comIO.lw.write(comIO.sessionId, logStr + "," + rsOverState, LogWriter.CmdState.rsOverState);
        }
    }

    static void logServerUrlStr(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("serverUrl") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.serverUrl);
        }
    }

    static void logLoginUrlStr(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("loginUrl") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.loginUrl);
        }
    }

    static void logDMmethods(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("dmMethod") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.dmMethod);
        }
    }

    static void logPstmethods(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("pstMethod") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.pstMethod);
        }
    }

    static void logRSmethods(ConnectionIO comIO, String logStr, int logCount, boolean mustLog) {
        boolean flag;
        boolean bl = flag = !(logCount > 1 && !mustLog || !debugLevel.equals("ALL") && debugLevel.indexOf("rsMethod") == -1);
        if (flag) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.rsMethod);
        }
    }

    static void logRecvOrder(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("normalRecvTurn") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.normalRecvTurn);
        }
    }

    static void logParamRecv(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("paramRecv") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.paramRecv);
        }
    }

    static void logCloseMethods(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("closeMethod") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.closeMethod);
        }
    }

    static void logCheckConnection(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("CheckConnectionIsValid") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.debug);
        }
    }

    static void logCheckPrepareSqlAndParameter(ConnectionIO comIO, String logStr) {
        if (debugLevel.equals("ALL") || debugLevel.indexOf("CheckPrepareSqlAndParameter") != -1) {
            comIO.lw.write(comIO.sessionId, logStr, LogWriter.CmdState.debug);
        }
    }

    static synchronized void logSlowSQL(ConnectionIO comIO, SlowSQLBean sqlBean) {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append("[SlowSQL]");
        logBuffer.append("\u3000");
        logBuffer.append(comIO.sessionId);
        logBuffer.append("\u3000");
        Date logDate = new Date();
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logBuffer.append(dateFormate.format(logDate));
        logBuffer.append("\u3000");
        logBuffer.append(sqlBean.getHost());
        logBuffer.append("\u3000");
        logBuffer.append(sqlBean.getUser());
        logBuffer.append("\u3000");
        logBuffer.append(sqlBean.getExecSqlTimes()).append(" second");
        logBuffer.append("\u3000");
        logBuffer.append(sqlBean.getExecSql());
        logBuffer.append("\r\n");
        comIO.lw.write(logBuffer.toString());
    }
}

