/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.config;

import org.apache.hertzbeat.base.dao.GeneralConfigDao;
import org.apache.hertzbeat.common.entity.dto.ModelProviderConfig;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.support.event.AiProviderConfigChangeEvent;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class LlmConfig {
    private static final Logger log = LoggerFactory.getLogger(LlmConfig.class);
    private final GeneralConfigDao generalConfigDao;
    private ApplicationContext applicationContext;

    public LlmConfig(GeneralConfigDao generalConfigDao, ApplicationContext applicationContext) {
        this.generalConfigDao = generalConfigDao;
        this.applicationContext = applicationContext;
    }

    @Bean
    public ChatClient openAiChatClient() {
        return this.createChatClient();
    }

    private ChatClient createChatClient() {
        GeneralConfig providerConfig = this.generalConfigDao.findByType("provider");
        if (providerConfig == null || providerConfig.getContent() == null) {
            log.warn("LLM Provider is not set, ChatClient bean will not be created");
            return null;
        }
        ModelProviderConfig modelProviderConfig = (ModelProviderConfig)JsonUtil.fromJson((String)providerConfig.getContent(), ModelProviderConfig.class);
        if (modelProviderConfig == null || modelProviderConfig.getApiKey() == null) {
            log.warn("LLM Provider configuration is incomplete, ChatClient bean will not be created");
            return null;
        }
        if (modelProviderConfig.getBaseUrl() == null) {
            if ("openai".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setBaseUrl("https://api.openai.com/v1");
            } else if ("zhipu".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setBaseUrl("https://open.bigmodel.cn/api/paas/v4");
            } else if ("zai".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setBaseUrl("https://api.z.ai/api/paas/v4");
            } else {
                modelProviderConfig.setBaseUrl("https://api.openai.com/v1");
            }
        }
        if (modelProviderConfig.getModel() == null) {
            if ("openai".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setModel("gpt-5");
            } else if ("zhipu".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setModel("glm-4.6");
            } else if ("zai".equals(modelProviderConfig.getCode())) {
                modelProviderConfig.setModel("glm-4.6");
            } else {
                modelProviderConfig.setModel("gpt-5");
            }
        }
        OpenAiApi.Builder builder = new OpenAiApi.Builder();
        builder.baseUrl(modelProviderConfig.getBaseUrl());
        builder.apiKey(modelProviderConfig.getApiKey());
        builder.completionsPath("/chat/completions");
        OpenAiChatOptions openAiChatOptions = OpenAiChatOptions.builder().model(modelProviderConfig.getModel()).temperature(Double.valueOf(0.3)).build();
        OpenAiChatModel openAiChatModel = OpenAiChatModel.builder().openAiApi(builder.build()).defaultOptions(openAiChatOptions).build();
        return ChatClient.create((ChatModel)openAiChatModel);
    }

    @EventListener(value={AiProviderConfigChangeEvent.class})
    public void onAiProviderConfigChange(AiProviderConfigChangeEvent event) {
        log.info("Provider configuration change event received, refreshing ChatClient bean");
        try {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)this.applicationContext;
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)configurableContext.getBeanFactory();
            if (beanFactory.containsSingleton("openAiChatClient")) {
                beanFactory.destroySingleton("openAiChatClient");
                log.info("Existing ChatClient bean destroyed");
            }
            ChatClient newChatClient = this.createChatClient();
            beanFactory.registerSingleton("openAiChatClient", (Object)newChatClient);
            log.info("ChatClient bean refreshed successfully with new AI provider configuration");
        }
        catch (Exception e) {
            log.error("Failed to refresh ChatClient bean after configuration change", (Throwable)e);
        }
    }
}

