/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.realtime;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.hertzbeat.alert.calculate.realtime.window.LogWorker;
import org.apache.hertzbeat.alert.calculate.realtime.window.TimeService;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.support.exception.CommonDataQueueUnknownException;
import org.apache.hertzbeat.common.util.BackoffUtils;
import org.apache.hertzbeat.common.util.ExponentialBackoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WindowedLogRealTimeAlertCalculator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WindowedLogRealTimeAlertCalculator.class);
    private static final int CALCULATE_THREADS = 3;
    private final CommonDataQueue dataQueue;
    private final TimeService timeService;
    private ThreadPoolExecutor dispatcherExecutor;
    private final LogWorker logWorker;

    public WindowedLogRealTimeAlertCalculator(CommonDataQueue dataQueue, TimeService timeService, LogWorker logWorker) {
        this.dataQueue = dataQueue;
        this.timeService = timeService;
        this.logWorker = logWorker;
    }

    @Override
    public void run() {
        ExponentialBackoff backoff = new ExponentialBackoff(50L, 1000L);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                LogEntry logEntry = this.dataQueue.pollLogEntry();
                if (logEntry == null) continue;
                backoff.reset();
                this.processLogEntry(logEntry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (CommonDataQueueUnknownException ue) {
                if (BackoffUtils.shouldContinueAfterBackoff((ExponentialBackoff)backoff)) continue;
                break;
            }
            catch (Exception e) {
                log.error("Error in log dispatch loop: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void processLogEntry(LogEntry logEntry) {
        long eventTimestamp = this.extractEventTimestamp(logEntry);
        if (!this.timeService.isValidTimestamp(eventTimestamp)) {
            log.warn("Dropping log with invalid timestamp: {}", (Object)eventTimestamp);
            return;
        }
        if (this.timeService.isLateData(eventTimestamp)) {
            log.warn("Dropping late data, timestamp: {}, watermark: {}", (Object)eventTimestamp, (Object)this.timeService.getCurrentWatermark());
            return;
        }
        this.timeService.updateMaxTimestamp(eventTimestamp);
        this.logWorker.reduceAndSendLogTask(logEntry);
    }

    private long extractEventTimestamp(LogEntry logEntry) {
        if (logEntry.getTimeUnixNano() != null && logEntry.getTimeUnixNano() != 0L) {
            return logEntry.getTimeUnixNano() / 1000000L;
        }
        if (logEntry.getObservedTimeUnixNano() != null && logEntry.getObservedTimeUnixNano() != 0L) {
            return logEntry.getObservedTimeUnixNano() / 1000000L;
        }
        return System.currentTimeMillis();
    }

    @PostConstruct
    public void start() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Alerter workerExecutor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("log-dispatcher-%d").build();
        this.dispatcherExecutor = new ThreadPoolExecutor(3, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        for (int i = 0; i < 3; ++i) {
            this.dispatcherExecutor.execute(this);
        }
    }

    @PreDestroy
    public void stop() {
        if (this.dispatcherExecutor != null) {
            this.dispatcherExecutor.shutdownNow();
        }
    }
}

