/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.realtime.window;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.hertzbeat.alert.calculate.realtime.window.AlarmEvaluator;
import org.apache.hertzbeat.alert.calculate.realtime.window.MatchingLogEvent;
import org.apache.hertzbeat.alert.calculate.realtime.window.TimeService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WindowAggregator
implements TimeService.WatermarkListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(WindowAggregator.class);
    private static final long DEFAULT_WINDOW_SIZE_MS = 60000L;
    private final AlarmEvaluator alarmEvaluator;
    private final BlockingQueue<MatchingLogEvent> eventQueue = new LinkedBlockingQueue<MatchingLogEvent>();
    private final Map<WindowKey, WindowData> activeWindows = new HashMap<WindowKey, WindowData>();
    private final Object windowLock = new Object();
    private ExecutorService aggregatorExecutor;

    public WindowAggregator(AlarmEvaluator alarmEvaluator) {
        this.alarmEvaluator = alarmEvaluator;
    }

    public void addMatchingLog(MatchingLogEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while adding matching log to aggregator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWatermark(TimeService.Watermark watermark) {
        ArrayList<WindowData> closedWindows;
        Iterator iterator = this.windowLock;
        synchronized (iterator) {
            closedWindows = new ArrayList<WindowData>();
            Iterator<Map.Entry<WindowKey, WindowData>> iterator2 = this.activeWindows.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<WindowKey, WindowData> entry = iterator2.next();
                WindowData windowData = entry.getValue();
                if (windowData.getEndTime() > watermark.getTimestamp()) continue;
                closedWindows.add(windowData);
                iterator2.remove();
                log.debug("Closing window: {} with {} matching logs", (Object)entry.getKey(), (Object)windowData.getMatchingLogs().size());
            }
        }
        for (WindowData windowData : closedWindows) {
            this.alarmEvaluator.sendAndProcessWindowData(windowData);
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                MatchingLogEvent event = this.eventQueue.take();
                this.processMatchingLogEvent(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                log.error("Error processing matching log event: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMatchingLogEvent(MatchingLogEvent event) {
        long windowSizeMs = this.getWindowSize(event.getAlertDefine());
        long eventTime = event.getEventTimestamp();
        long windowStart = eventTime / windowSizeMs * windowSizeMs;
        long windowEnd = windowStart + windowSizeMs;
        WindowKey windowKey = new WindowKey(event.getAlertDefine().getId(), windowStart, windowEnd);
        Object object = this.windowLock;
        synchronized (object) {
            WindowData windowData = this.activeWindows.computeIfAbsent(windowKey, key -> new WindowData((WindowKey)key, event.getAlertDefine()));
            windowData.addMatchingLog(event);
            log.debug("Added matching log to window: {} (total logs: {})", (Object)windowKey, (Object)windowData.getMatchingLogs().size());
        }
    }

    private long getWindowSize(AlertDefine alertDefine) {
        if (alertDefine.getPeriod() != null) {
            return alertDefine.getPeriod() * 1000;
        }
        log.info("Using default window size of {} ms for alert define: {}", (Object)60000L, (Object)alertDefine.getName());
        return 60000L;
    }

    @PostConstruct
    public void start() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("WindowAggregator executor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("window-aggregator-%d").build();
        this.aggregatorExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.aggregatorExecutor.submit(this);
        log.info("WindowAggregator started");
    }

    @PreDestroy
    public void stop() {
        if (this.aggregatorExecutor != null && !this.aggregatorExecutor.isShutdown()) {
            log.info("Shutting down WindowAggregator executor...");
            this.aggregatorExecutor.shutdown();
            try {
                if (!this.aggregatorExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.warn("WindowAggregator executor did not terminate within 10 seconds, forcing shutdown");
                    this.aggregatorExecutor.shutdownNow();
                    if (!this.aggregatorExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.error("WindowAggregator executor did not terminate");
                    }
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for WindowAggregator executor to terminate");
                this.aggregatorExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        log.info("WindowAggregator stopped");
    }

    public static class WindowData {
        private final WindowKey windowKey;
        private final AlertDefine alertDefine;
        private final List<MatchingLogEvent> matchingLogs = new ArrayList<MatchingLogEvent>();
        private final long createdTime;

        public WindowData(WindowKey windowKey, AlertDefine alertDefine) {
            this.windowKey = windowKey;
            this.alertDefine = alertDefine;
            this.createdTime = System.currentTimeMillis();
        }

        public void addMatchingLog(MatchingLogEvent event) {
            this.matchingLogs.add(event);
        }

        public List<MatchingLogEvent> getMatchingLogs() {
            return new ArrayList<MatchingLogEvent>(this.matchingLogs);
        }

        public long getStartTime() {
            return this.windowKey.getStartTime();
        }

        public long getEndTime() {
            return this.windowKey.getEndTime();
        }

        public WindowKey getWindowKey() {
            return this.windowKey;
        }

        public AlertDefine getAlertDefine() {
            return this.alertDefine;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }
    }

    public static class WindowKey {
        private final long alertDefineId;
        private final long startTime;
        private final long endTime;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WindowKey)) {
                return false;
            }
            WindowKey other = (WindowKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAlertDefineId() != other.getAlertDefineId()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            return this.getEndTime() == other.getEndTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof WindowKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $alertDefineId = this.getAlertDefineId();
            result = result * 59 + (int)($alertDefineId >>> 32 ^ $alertDefineId);
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $endTime = this.getEndTime();
            result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
            return result;
        }

        public String toString() {
            return "WindowAggregator.WindowKey(alertDefineId=" + this.getAlertDefineId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }

        public long getAlertDefineId() {
            return this.alertDefineId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public WindowKey(long alertDefineId, long startTime, long endTime) {
            this.alertDefineId = alertDefineId;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

