/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.entity.dto.sms.TwilioSmsProperties;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwilioSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(TwilioSmsClientImpl.class);
    private static final String API_URL_FORMAT = "https://api.twilio.com/2010-04-01/Accounts/%s/Messages.json";
    private static final String MESSAGE_TEMPLATE = "Instance: %s, Priority: %s, Content: %s";
    private final String accountSid;
    private final String authToken;
    private final String twilioPhoneNumber;

    public TwilioSmsClientImpl(TwilioSmsProperties config) {
        if (config != null) {
            this.accountSid = config.getAccountSid();
            this.authToken = config.getAuthToken();
            this.twilioPhoneNumber = config.getTwilioPhoneNumber();
        } else {
            this.accountSid = "";
            this.authToken = "";
            this.twilioPhoneNumber = "";
        }
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        String instance = null;
        String priority = null;
        String content = null;
        if (alert.getCommonLabels() != null) {
            instance = alert.getCommonLabels().get("instance") == null ? alert.getGroupKey() : (String)alert.getCommonLabels().get("instance");
            priority = alert.getCommonLabels().get("priority") == null ? "unknown" : (String)alert.getCommonLabels().get("priority");
            content = (String)alert.getCommonAnnotations().get("summary");
            String string = content = content == null ? (String)alert.getCommonAnnotations().get("description") : content;
            if (content == null) {
                content = alert.getCommonAnnotations().values().stream().findFirst().orElse(null);
            }
        }
        this.send(receiver.getPhone(), this.createMessage(instance, priority, content));
    }

    private String createMessage(String instance, String priority, String content) {
        return String.format(MESSAGE_TEMPLATE, instance, priority, content);
    }

    private void send(String phoneNumber, String message) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String endpoint = String.format(API_URL_FORMAT, this.accountSid);
            URI requestUri = new URI(endpoint);
            HttpPost httpPost = this.createHttpPost(requestUri, phoneNumber, message);
            log.info("Sending Twilio SMS request to {}", (Object)requestUri);
            this.executeRequest(httpClient, httpPost, phoneNumber);
        }
        catch (Exception e) {
            log.warn("Failed to send SMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    private HttpPost createHttpPost(URI requestUri, String toNumber, String message) {
        HttpPost httpPost = new HttpPost(requestUri);
        String auth = this.accountSid + ":" + this.authToken;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        httpPost.setHeader("Authorization", "Basic " + encodedAuth);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("To", toNumber));
        parameters.add(new BasicNameValuePair("From", this.twilioPhoneNumber));
        parameters.add(new BasicNameValuePair("Body", message));
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            return httpPost;
        }
        catch (Exception e) {
            log.error("Failed to create HTTP request: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    private void executeRequest(CloseableHttpClient httpClient, HttpPost httpPost, String phoneNumber) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("SMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
            if (statusCode < 200 || statusCode >= 300) {
                if (responseBody.contains("21608")) {
                    throw new SendMessageException("The Twilio trial account can only send SMS to verified phone numbers");
                }
                throw new SendMessageException("HTTP request failed with status code: " + statusCode + ", response: " + responseBody);
            }
            JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
            if (jsonResponse == null) {
                throw new SendMessageException(statusCode + ":" + responseBody);
            }
            JsonNode sidNode = jsonResponse.get("sid");
            if (sidNode == null) {
                throw new SendMessageException(statusCode + ":" + responseBody);
            }
            String sid = sidNode.asText();
            log.info("Successfully sent SMS to phone: {}, sid: {}", (Object)phoneNumber, (Object)sid);
        }
    }

    @Override
    public String getType() {
        return "twilio";
    }

    @Override
    public boolean checkConfig() {
        return !this.accountSid.isBlank() && !this.authToken.isBlank() && !this.twilioPhoneNumber.isBlank();
    }
}

