/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.service.AppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="I18N International Resource API")
@RestController
@RequestMapping(path={"/api/i18n"}, produces={"application/json"})
public class I18nController {
    @Autowired
    private AppService appService;

    @GetMapping(value={"/{lang}"})
    @Operation(summary="Query total i 18 n internationalized text resources", description="Query total i18n internationalized text resources")
    public ResponseEntity<Message<Map<String, String>>> queryI18n(@Parameter(description="en: language type", example="zh-CN") @PathVariable(name="lang", required=false) String lang) {
        if (lang == null || lang.isEmpty()) {
            lang = "zh-CN";
        }
        lang = "zh-cn".equalsIgnoreCase(lang) || "zh_cn".equalsIgnoreCase(lang) ? "zh-CN" : lang;
        lang = "en-us".equalsIgnoreCase(lang) || "en_us".equalsIgnoreCase(lang) ? "en-US" : lang;
        Map<String, String> i18nResource = this.appService.getI18nResources(lang);
        return ResponseEntity.ok((Object)Message.success(i18nResource));
    }
}

