/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Field;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.RowData;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.UnsupportedEncodingException;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection connection;
    String curr_db;
    String curr_user;
    private final boolean a = false;
    int READ_ANY = 1;
    String schemaString = null;
    MessageFormat messageFormat = null;
    private Boolean useLike = false;

    public DatabaseMetaData(java.sql.Connection conn, String database) throws SQLException {
        this.connection = (Connection)conn;
        this.curr_db = this.connection.getCatalog();
        this.curr_user = this.connection.getUser();
        this.useLike = ((Connection)conn).useLike;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "allProceduresAreCallable");
        }
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "allTablesAreSelectable");
        }
        boolean selectedAll = true;
        int authority = 0;
        String curruser_name = this.getUserName();
        Statement stm = (Statement)this.connection.createStatement();
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.allTablesAreSelectable"));
        Object[] selectTabObj = new Object[]{"'" + curruser_name + "'", "'" + curruser_name + "'"};
        String sql = this.messageFormat.format(selectTabObj);
        java.sql.ResultSet rs = stm.executeQuery(sql);
        while (rs.next()) {
            authority = rs.getInt(1);
            if ((authority & this.READ_ANY) == 1) continue;
            selectedAll = false;
            break;
        }
        stm.close();
        rs = null;
        stm = null;
        curruser_name = null;
        sql = null;
        return selectedAll;
    }

    @Override
    public String getURL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getURL");
        }
        return this.connection.getConnectionUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getUserName");
        }
        String user_name = null;
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getUserName"));
        String sql = this.messageFormat.format(null);
        Statement stm = (Statement)this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery(sql);
        while (rs.next()) {
            user_name = rs.getString(1);
        }
        stm.close();
        stm = null;
        rs = null;
        return user_name;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "isReadOnly");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedHigh");
        }
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedLow");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedAtStart");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedAtEnd");
        }
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseProductName");
        }
        String dbNameStr = this.getDatabaseProductVersion();
        if (this.connection.isIsora()) {
            return "Oracle";
        }
        if (!"".equalsIgnoreCase(ReplaceEnum.databaseProductName.getReplaceStr())) {
            return ReplaceEnum.databaseProductName.getReplaceStr();
        }
        return dbNameStr.substring(0, dbNameStr.lastIndexOf(" "));
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseProductVersion");
        }
        this.checkConnectionOpen();
        String versionStr = null;
        versionStr = this.connection.isIsora() ? "11" : (!"".equals(ReplaceEnum.databaseProductVersion.getReplaceStr()) ? ReplaceEnum.databaseProductVersion.getReplaceStr() : this.getDatabaseInfo());
        return versionStr;
    }

    private String getDatabaseInfo() throws SQLException {
        StringBuilder databaseInfo = new StringBuilder();
        String databaseInfo1 = "";
        java.sql.Statement stm = this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery("show version");
        if (rs.next()) {
            databaseInfo1 = rs.getString(1);
        }
        rs.close();
        stm.close();
        String databaseInfo2 = "";
        if (this.connection.isdbkernel) {
            String sql = "show db_kernel";
            stm = this.connection.createStatement();
            rs = stm.executeQuery(sql);
            if (rs.next()) {
                databaseInfo2 = rs.getString(1);
            }
            rs.close();
            stm.close();
            if (databaseInfo1.contains("SQL Server")) {
                databaseInfo.append("XuGu SQL Server ").append(databaseInfo2);
            } else if (databaseInfo1.contains("XuguDB")) {
                databaseInfo.append("XuguDB ").append(databaseInfo2);
            } else {
                databaseInfo.append(ReplaceEnum.databaseProductName.getReplaceStr()).append(databaseInfo2);
            }
        } else {
            databaseInfo.append(databaseInfo1);
        }
        return databaseInfo.toString();
    }

    @Override
    public String getDriverName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverName");
        }
        return ReplaceEnum.driverName.getReplaceStr();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverVersion");
        }
        return ReplaceEnum.driverVersion.getReplaceStr();
    }

    public String getJDBCVersionDate() {
        return ReplaceEnum.jdbcVersionDateString.getReplaceStr();
    }

    @Override
    public int getDriverMajorVersion() {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverMajorVersion");
        }
        return Integer.parseInt(ReplaceEnum.driverMajorVersion.getReplaceStr());
    }

    @Override
    public int getDriverMinorVersion() {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverMinorVersion");
        }
        return Integer.parseInt(ReplaceEnum.driverMinorVersion.getReplaceStr());
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "usesLocalFiles");
        }
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "usesLocalFilePerTable");
        }
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMixedCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesUpperCaseIdentifiers");
        }
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesLowerCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesMixedCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMixedCaseQuotedIdentifiers");
        }
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesUpperCaseQuotedIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesLowerCaseQuotedIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesMixedCaseQuotedIdentifiers");
        }
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getIdentifierQuoteString");
        }
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSQLKeywords");
        }
        Statement stm = (Statement)this.connection.createStatement();
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSQLKeywords");
        Object[] indexObj = new Object[]{};
        String sql = this.messageFormat.format(indexObj);
        java.sql.ResultSet resultSet = stm.executeQuery(sql);
        StringBuffer stringBuffer = new StringBuffer();
        while (resultSet.next()) {
            stringBuffer.append(resultSet.getString(1)).append(",");
        }
        resultSet.close();
        stm.close();
        int length = stringBuffer.length() - 1;
        return stringBuffer.substring(0, length);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getNumericFunctions");
        }
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getNumericFunctions"));
        String sql = this.messageFormat.format(null);
        Statement stm = (Statement)this.connection.createStatement();
        String funName = null;
        java.sql.ResultSet rs = stm.executeQuery(sql);
        if (rs.next()) {
            funName = rs.getString(1);
        }
        stm.close();
        stm = null;
        rs = null;
        return funName;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getStringFunctions");
        }
        return new String("ATOF,ATOI,BOX,BTRIM,CONCAT,HEADING,INSTR,LEN,LOWER,LTRIM,PINYIN,PINYIN1,POINT,POSITION,REPLACE,REPLICATE,REVERSE_STR,RTRIM,STUFF,SUBSTR,TAILING,UPPER");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSystemFunctions");
        }
        return new String("ISNULL,CURRENT_DATE,CURRENT_DATABASE,CURRENT_DB,CURRENT_DB_ID,CURRENT_IP,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURRENT_USERID");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTimeDateFunctions");
        }
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTimeDateFunctions"));
        String sql = this.messageFormat.format(null);
        String timeFun = null;
        java.sql.Statement stm = this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery(sql);
        timeFun = this.rsToString(rs);
        stm.close();
        stm = null;
        rs = null;
        return timeFun;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSearchStringEscape");
        }
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getExtraNameCharacters");
        }
        return "$#";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsAlterTableWithAddColumn");
        }
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsAlterTableWithDropColumn");
        }
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsColumnAliasing");
        }
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullPlusNonNullIsNull");
        }
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsConvert");
        }
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsConvert  " + fromType + " , " + toType);
        }
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTableCorrelationNames");
        }
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDifferentTableCorrelationNames");
        }
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsExpressionsInOrderBy");
        }
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOrderByUnrelated");
        }
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupBy");
        }
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupByUnrelated");
        }
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupByBeyondSelect");
        }
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsLikeEscapeClause");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleResultSets");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleTransactions");
        }
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsNonNullableColumns");
        }
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMinimumSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCoreSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsExtendedSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92EntryLevelSQL");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92IntermediateSQL");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92FullSQL");
        }
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsIntegrityEnhancementFacility");
        }
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOuterJoins");
        }
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsFullOuterJoins");
        }
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsLimitedOuterJoins");
        }
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSchemaTerm");
        }
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedureTerm");
        }
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogTerm");
        }
        return "DATABASE";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "isCatalogAtStart");
        }
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogSeparator");
        }
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInDataManipulation");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInProcedureCalls");
        }
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInTableDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInIndexDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInPrivilegeDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInDataManipulation");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInProcedureCalls");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInTableDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInIndexDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInPrivilegeDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsPositionedDelete");
        }
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsPositionedUpdate");
        }
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSelectForUpdate");
        }
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStoredProcedures");
        }
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInComparisons");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInExists");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInIns");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInQuantifieds");
        }
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCorrelatedSubqueries");
        }
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsUnion");
        }
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsUnionAll");
        }
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenCursorsAcrossCommit");
        }
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenCursorsAcrossRollback");
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenStatementsAcrossCommit");
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenStatementsAcrossRollback");
        }
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxBinaryLiteralLength");
        }
        return 512;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCharLiteralLength");
        }
        return 64;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInGroupBy");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInIndex");
        }
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInOrderBy");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInSelect");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInTable");
        }
        return 1024;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxConnections");
        }
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCursorNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxIndexLength");
        }
        return 1024;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxSchemaNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxProcedureNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCatalogNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxRowSize");
        }
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "doesMaxRowSizeIncludeBlobs");
        }
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxStatementLength");
        }
        return 65536;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxStatements");
        }
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxTableNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxTablesInSelect");
        }
        return 32;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxUserNameLength");
        }
        return 64;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDefaultTransactionIsolation");
        }
        return this.connection.getTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTransactions");
        }
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTransactionIsolationLevel");
        }
        return level == 2 || level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDataDefinitionAndDataManipulationTransactions");
        }
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDataManipulationTransactionsOnly");
        }
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "dataDefinitionCausesTransactionCommit");
        }
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "dataDefinitionIgnoredInTransactions");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedures  " + catalog + " , " + schemaPattern + " , " + procedureNamePattern);
        }
        java.sql.ResultSet rs = null;
        String sql = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        Object[] proceObj = null;
        if (procedureNamePattern.equals("%")) {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedures%"));
            proceObj = new Object[]{"'" + real_catalog + "'", "'1'", real_schema};
            sql = this.messageFormat.format(proceObj);
        } else {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedures"));
            proceObj = new Object[]{"'" + real_catalog + "'", "'1'", real_schema, "'" + procedureNamePattern + "'"};
            sql = this.messageFormat.format(proceObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Object[] proceObj;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedureColumns  " + catalog + " , " + schemaPattern + " , " + procedureNamePattern + " , " + columnNamePattern);
        }
        java.sql.ResultSet rs = null;
        String sql = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String real_catalog = catalog != null ? catalog : this.getRealCatalog(catalog);
        String real_schema = schemaPattern != null ? "'" + schemaPattern + "'" : this.getRealSchemas(catalog, schemaPattern);
        String real_procedureName = procedureNamePattern != null ? "'" + procedureNamePattern + "'" : "'%'";
        String real_columnName = columnNamePattern != null && !columnNamePattern.equalsIgnoreCase("%") ? "'" + columnNamePattern + "'" : "'%'";
        Field[] field = new Field[]{new Field("PROCEDURE_CAT", 30, 30, 1, real_catalog), new Field("PROCEDURE_SCHEM", 30, 30, 1, real_catalog), new Field("PROCEDURE_NAME", 30, 30, 1, real_catalog), new Field("COLUMN_NAME", 30, 30, 1, real_catalog), new Field("COLUMN_TYPE", 4, 2, 1, real_catalog), new Field("DATA_TYPE", 5, 4, 1, real_catalog), new Field("TYPE_NAME", 30, 30, 1, real_catalog), new Field("PRECISION", 5, 4, 1, real_catalog), new Field("LENGTH", 5, 4, 1, real_catalog), new Field("SCALE", 4, 2, 1, real_catalog), new Field("RADIX", 4, 2, 1, real_catalog), new Field("NULLABLE", 4, 2, 1, real_catalog), new Field("COMMENT", 30, 30, 1, real_catalog), new Field("COLUMN_DEF", 30, 30, 1, real_catalog), new Field("SQL_DATA_TYPE", 5, 4, 1, real_catalog), new Field("SQL_DATETIME_SUB", 5, 4, 1, real_catalog), new Field("CHAR_OCTET_LENGTH", 5, 4, 1, real_catalog), new Field("ORDINAL_POSITION", 5, 4, 1, real_catalog), new Field("IS_NULLABLE", 30, 30, 1, real_catalog), new Field("SPECIFIC_NAME", 30, 30, 1, real_catalog)};
        if (real_columnName.equalsIgnoreCase("'%'")) {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedureColumns%"));
            proceObj = new Object[]{"'" + real_catalog + "'", real_schema, real_procedureName, real_columnName};
            sql = this.messageFormat.format(proceObj);
        } else {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedureColumns"));
            proceObj = new Object[]{schemaPattern, real_procedureName, real_columnName};
            sql = this.messageFormat.format(proceObj);
        }
        rs = stm.executeQuery(sql);
        Vector array = new Vector();
        RowData rd = new RowData(array);
        ResultSet rs1 = new ResultSet(this.connection, stm, real_catalog, field, rd, sql);
        while (rs.next()) {
            byte[][] rowData = new byte[20][];
            rowData[0] = real_catalog.getBytes();
            rowData[1] = rs.getBytes("SCHEMA_NAME");
            rowData[2] = rs.getBytes("PROC_NAME");
            rowData[3] = rs.getBytes("ARG_NAME");
            int inOutType = rs.getShort("IN_OUT");
            if (inOutType == 0) {
                inOutType = 5;
            } else if (inOutType == 1) {
                inOutType = 1;
            } else if (inOutType == 2) {
                inOutType = 4;
            } else if (inOutType == 3) {
                inOutType = 2;
            }
            rowData[4] = new byte[2];
            rowData[4][0] = (byte)((inOutType & 0xFF00) >> 8);
            rowData[4][1] = (byte)(inOutType & 0xFF);
            int typeId = TypesUtil.toJavaType(TypesUtil.getRedhorseType(rs.getString("TYPE_NAME")));
            rowData[5] = new byte[4];
            rowData[5][0] = (byte)((typeId & 0xFF000000) >> 24);
            rowData[5][1] = (byte)((typeId & 0xFF0000) >> 16);
            rowData[5][2] = (byte)((typeId & 0xFF00) >> 8);
            rowData[5][3] = (byte)(typeId & 0xFF);
            rowData[6] = rs.getBytes("TYPE_NAME");
            rowData[7] = rs.getBytes("DATA_PRECISION");
            rowData[8] = rs.getBytes("DATA_PRECISION");
            rowData[9] = rs.getBytes("DATA_SCALE");
            rowData[10] = null;
            rowData[11] = null;
            rowData[12] = null;
            rowData[13] = rs.getBytes("DEFAULT_VALUE");
            rowData[14] = null;
            rowData[15] = null;
            rowData[16] = null;
            rowData[17] = null;
            rowData[18] = null;
            rowData[19] = rs.getBytes("PROC_NAME");
            rs1.addRow(rowData);
        }
        rs1.setRsIsOver(true);
        rs1.setManificateRs(true);
        rs.close();
        stm.close();
        return rs1;
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Object[] tabObj;
        if (Command.debug) {
            String typesStr = "";
            if (types != null && types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    typesStr = i == types.length - 1 ? typesStr + types[i] : typesStr + types[i] + ",";
                }
            }
            if (typesStr.equals("")) {
                typesStr = "null";
            }
            Command.logDMmethods(this.connection.io, "getTables   " + catalog + " , " + schemaPattern + " , " + tableNamePattern + " , " + typesStr);
        }
        Connection conn = null;
        java.sql.ResultSet rs = null;
        conn = this.connection;
        java.sql.Statement stm = conn.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        String sql2 = "";
        String sql3 = "";
        String sql4 = "";
        String sql6 = "";
        String sql7 = "";
        String sql8 = "";
        String sql9 = "";
        if (this.useLike.booleanValue()) {
            tabObj = new Object[]{"'" + real_catalog + "'", "'" + tableNamePattern + "'", real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTabLike"));
            sql2 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTemtabLike"));
            sql3 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesViewLike"));
            sql4 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesSynLike"));
            sql6 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesProLike"));
            sql7 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesFunLike"));
            sql8 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesUDTLike"));
            sql9 = this.messageFormat.format(tabObj);
        } else if (tableNamePattern.equalsIgnoreCase("%")) {
            tabObj = new Object[]{"'" + real_catalog + "'", real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTab%"));
            sql2 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTemtab%"));
            sql3 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesView%"));
            sql4 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesSyn%"));
            sql6 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesPro%"));
            sql7 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesFun%"));
            sql8 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesUDT%"));
            sql9 = this.messageFormat.format(tabObj);
        } else {
            tabObj = new Object[]{"'" + real_catalog + "'", "'" + tableNamePattern + "'", real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTab"));
            sql2 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTemtab"));
            sql3 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesView"));
            sql4 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesSyn"));
            sql6 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesPro"));
            sql7 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesFun"));
            sql8 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesUDT"));
            sql9 = this.messageFormat.format(tabObj);
        }
        String temp_type = null;
        String total_sql = "";
        String innerSql = null;
        MessageFormat totalFormat = SQLCommon.getMessageFormat("DatabaseMetadata.selectSql");
        String orderSql = SQLCommon.getMessageFormat("DatabaseMetadata.getTablesOrder").format(null);
        StringBuffer exeSqlBuffer = new StringBuffer();
        if (types == null) {
            innerSql = exeSqlBuffer.append("(").append(sql2).append(" union all ").append(sql3).append(" union all ").append(sql4).append(" union all ").append(sql6).append(" union all ").append(sql7).append(" union all ").append(sql8).append(" union all ").append(sql9).append(")").append(orderSql).toString();
            Object[] inObj = new Object[]{innerSql};
            total_sql = totalFormat.format(inObj);
        } else {
            String supportTypes = "TABLE,VIEW,GLOBAL TEMPORARY,SYNONYM,PROCEDURE,FUNCTION,UDT";
            for (int i = 0; i < types.length; ++i) {
                temp_type = types[i];
                if (supportTypes.indexOf(temp_type.toUpperCase()) == -1) continue;
                if (exeSqlBuffer.length() != 0) {
                    exeSqlBuffer.append(" union all ");
                } else {
                    exeSqlBuffer.append("(");
                }
                if (temp_type.equalsIgnoreCase("TABLE")) {
                    exeSqlBuffer.append(sql2);
                }
                if (temp_type.equalsIgnoreCase("GLOBAL TEMPORARY")) {
                    exeSqlBuffer.append(sql3);
                }
                if (temp_type.equalsIgnoreCase("VIEW")) {
                    exeSqlBuffer.append(sql4);
                }
                if (temp_type.equalsIgnoreCase("SYNONYM")) {
                    exeSqlBuffer.append(sql6);
                }
                if (temp_type.equalsIgnoreCase("PROCEDURE")) {
                    exeSqlBuffer.append(sql7);
                }
                if (temp_type.equalsIgnoreCase("FUNCTION")) {
                    exeSqlBuffer.append(sql8);
                }
                if (!temp_type.equalsIgnoreCase("UDT")) continue;
                exeSqlBuffer.append(sql9);
            }
            if (exeSqlBuffer.length() > 0) {
                exeSqlBuffer.append(") " + orderSql);
                Object[] inObj = new Object[]{exeSqlBuffer.toString()};
                total_sql = totalFormat.format(inObj);
            } else {
                Object[] inObj = new Object[]{"dual where id is null"};
                total_sql = totalFormat.format(inObj);
            }
        }
        rs = stm.executeQuery(total_sql);
        return rs;
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemas");
        Object[] schemaObj = new Object[]{"'" + this.curr_db + "'"};
        java.sql.ResultSet rs = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String sql = this.messageFormat.format(schemaObj);
        rs = stm.executeQuery(sql);
        return rs;
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogs");
        }
        this.checkConnectionOpen();
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCatalogs");
        Statement stm = (Statement)this.connection.createStatement(false);
        java.sql.ResultSet rs = stm.executeQuery(this.messageFormat.format(null));
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTableTypes");
        }
        Vector typelist = new Vector();
        String[] tabTypes = new String[]{"TABLE", "VIEW", "GLOBAL TEMPORARY", "SYSTEM TABLE", "LOCAL TEMPORARY", "SYNONYM", "PROCEDURE", "FUNCTION", "UDT"};
        RowData rd = new RowData(typelist);
        Field[] field = new Field[]{new Field("TABLE_TYPE", 30, 20, 0, this.curr_db)};
        ResultSet rs = new ResultSet(this.connection, (Statement)this.connection.createStatement(), this.curr_db, field, rd, null);
        Object b1 = null;
        try {
            for (int i = 0; i < tabTypes.length; ++i) {
                b1 = new byte[1][];
                b1[0] = tabTypes[i].getBytes();
                rs.addRow((byte[][])b1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getColumns   " + catalog + " , " + schemaPattern + " , " + tableNamePattern + " , " + columnNamePattern);
        }
        String table_type = "";
        java.sql.ResultSet rs = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        String sql2 = "";
        String[] colObj = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        if ((table_type = this.getTableRealType(stm, tableNamePattern, real_schema)).equalsIgnoreCase("table")) {
            if (this.useLike.booleanValue()) {
                if (columnNamePattern.equalsIgnoreCase("%")) {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTab%Like");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                } else {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTabLike");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                }
            } else if (columnNamePattern.equalsIgnoreCase("%")) {
                if (tableNamePattern == null || tableNamePattern.equals("%")) {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTabNull%");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                } else {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTab%");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                }
            } else if (tableNamePattern == null || tableNamePattern.equals("%")) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTabNull");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTab");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            }
            rs = stm.executeQuery(sql2);
        } else {
            if (this.useLike.booleanValue()) {
                if (columnNamePattern.equalsIgnoreCase("%")) {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsView%Like");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                } else {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsViewLike");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                }
            } else if (columnNamePattern.equalsIgnoreCase("%")) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsView%");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsView");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            }
            rs = stm.executeQuery(sql2);
        }
        return rs;
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getColumnPrivileges\u672a\u5b9e\u73b0       " + catalog + " , " + schema + " , " + table + " , " + columnNamePattern);
        }
        this.checkConnectionOpen();
        throw SQLCommon.unSupportException("DatabaseMetadata.getColumnPrivileges", "String,String.String,String");
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTablePrivileges\u672a\u5b9e\u73b0       " + catalog + " , " + schemaPattern + " , " + tableNamePattern);
        }
        throw SQLCommon.unSupportException("DatabaseMetadata.getTablePrivileges", "String,String.String");
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getBestRowIdentifier   " + catalog + " , " + schema + " , " + table + " , " + scope + " , " + nullable);
        }
        this.checkConnectionOpen();
        java.sql.ResultSet rs = null;
        String sql = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (table == null || table.equals("") || table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getBestRowIdentifier%");
            Object[] identifierObjAll = new Object[]{scope, 1, 1, real_schema};
            sql = this.messageFormat.format(identifierObjAll);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getBestRowIdentifier");
            Object[] identifierObj = new Object[]{scope, 1, 1, real_schema, "'" + table + "'"};
            sql = this.messageFormat.format(identifierObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Object[] exportObj;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getExportedKeys   " + catalog + " , " + schema + " , " + table);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        int f = 32;
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        String sql = null;
        Statement stm = (Statement)this.connection.createStatement();
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("KEY_SEQ", 4, 2, 1, real_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_catalog), new Field("DELETE_RULE", 4, 2, 1, real_catalog), new Field("FK_NAME", 30, 20, 1, real_catalog), new Field("PK_NAME", 30, 20, 1, real_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_catalog)};
        Vector array = new Vector();
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, real_catalog, field, rowData, null);
        if (table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getExportedKeys%");
            exportObj = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema};
            sql = this.messageFormat.format(exportObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getExportedKeys");
            exportObj = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema, "'" + table + "'"};
            sql = this.messageFormat.format(exportObj);
        }
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            int i = 1;
            String f_fColumn = rs1.getString(6);
            String fColumn = null;
            String pColumn = rs1.getString(2);
            int post = 0;
            int kpost = 0;
            fColumn = f_fColumn.indexOf("(") != -1 ? f_fColumn.substring(f_fColumn.indexOf("(") + 1, f_fColumn.indexOf(")")) : f_fColumn;
            try {
                Object realData;
                while ((post = fColumn.indexOf(",")) != -1) {
                    kpost = pColumn.indexOf(",");
                    realData = new byte[14][];
                    realData[0] = real_catalog.getBytes();
                    realData[1] = rs1.getString(10).getBytes();
                    realData[2] = rs1.getString(9).getBytes();
                    realData[3] = pColumn.substring(0, kpost).getBytes();
                    pColumn = pColumn.substring(kpost + 1);
                    realData[4] = real_catalog.getBytes();
                    realData[5] = rs1.getString(7).getBytes();
                    realData[6] = rs1.getString(8).getBytes();
                    f = rs1.getString(3).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 1;
                            break;
                        }
                    }
                    f = rs1.getString(4).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 1;
                            break;
                        }
                    }
                    realData[11] = rs1.getString(5).getBytes();
                    realData[12] = rs1.getString(1).getBytes();
                    realData[13] = new byte[2];
                    realData[13][0] = 0;
                    realData[13][1] = 5;
                    String p1 = fColumn.substring(0, post);
                    fColumn = fColumn.substring(post + 1);
                    realData[7] = p1.getBytes();
                    realData[8] = new byte[2];
                    realData[8][0] = (byte)((i & 0xFF00) >> 8);
                    realData[8][1] = (byte)(i & 0xFF);
                    i = (short)(i + 1);
                    rowData.addRow((byte[][])realData);
                    realData = null;
                }
                realData = new byte[14][];
                realData[0] = real_catalog.getBytes();
                realData[1] = rs1.getString(10).getBytes();
                realData[2] = rs1.getString(9).getBytes();
                realData[3] = pColumn.substring(0).getBytes();
                realData[4] = real_catalog.getBytes();
                realData[5] = rs1.getString(7).getBytes();
                realData[6] = rs1.getString(8).getBytes();
                f = rs1.getString(3).charAt(0);
                switch (f) {
                    case 110: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(4).charAt(0);
                switch (f) {
                    case 110: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 1;
                        break;
                    }
                }
                realData[11] = rs1.getString(5).getBytes();
                realData[12] = rs1.getString(1).getBytes();
                realData[13] = new byte[2];
                realData[13][0] = 0;
                realData[13][1] = 5;
                fColumn = fColumn.substring(0);
                realData[7] = fColumn.getBytes();
                realData[8] = new byte[2];
                realData[8][0] = (byte)((i & 0xFF00) >> 8);
                realData[8][1] = (byte)(i & 0xFF);
                rowData.addRow((byte[][])realData);
                realData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1.close();
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCrossReference   " + primaryCatalog + " , " + primarySchema + " , " + primaryTable + " , " + foreignCatalog + " , " + foreignSchema + " , " + foreignTable);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String real_p_schema = this.getRealSchemas(primaryCatalog, primarySchema);
        String real_f_catalog = this.getRealCatalog(foreignCatalog);
        String real_f_schema = this.getRealSchemas(foreignCatalog, foreignSchema);
        int f = 32;
        Statement stm = (Statement)this.connection.createStatement();
        if (primaryTable == null || primaryTable.equals("")) {
            primaryTable = "%";
        }
        if (foreignTable == null || foreignTable.equals("")) {
            foreignTable = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_f_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_f_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_f_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_f_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_f_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_f_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_f_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_f_catalog), new Field("KEY_SEQ", 4, 2, 1, real_f_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_f_catalog), new Field("DELETE_RULE", 4, 2, 1, real_f_catalog), new Field("FK_NAME", 30, 20, 1, real_f_catalog), new Field("PK_NAME", 30, 20, 1, real_f_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_f_catalog)};
        String sql = null;
        Object[] crossObj = null;
        Vector array = new Vector();
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, foreignCatalog, field, rowData, null);
        if (primaryTable.equals("%") && foreignTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferenceAll%");
            crossObj = new Object[]{"'" + this.curr_db + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema};
        } else if (primaryTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferencePrimary%");
            crossObj = new Object[]{"'" + this.curr_db + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema, "'" + foreignTable + "'"};
        } else if (foreignTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferenceForeign%");
            crossObj = new Object[]{"'" + this.curr_db + "'", "'" + primaryTable + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReference");
            crossObj = new Object[]{"'" + this.curr_db + "'", "'" + primaryTable + "'", real_p_schema, "'" + this.curr_db + "'", "'" + foreignTable + "'", real_f_schema};
        }
        sql = this.messageFormat.format(crossObj);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            int i = 1;
            String p_fColumn = rs1.getString(4);
            String fColumn = null;
            String pColumn = rs1.getString(2);
            int post = 0;
            int kpost = 0;
            fColumn = p_fColumn.indexOf("(") != -1 ? p_fColumn.substring(p_fColumn.indexOf("(") + 1, p_fColumn.indexOf(")")) : p_fColumn;
            try {
                Object realData;
                while ((post = fColumn.indexOf(",")) != -1) {
                    kpost = pColumn.indexOf(",");
                    realData = new byte[14][];
                    realData[0] = rs1.getString(11).getBytes();
                    realData[1] = rs1.getString(9).getBytes();
                    realData[2] = rs1.getString(7).getBytes();
                    realData[3] = pColumn.substring(0, kpost).getBytes();
                    pColumn = pColumn.substring(kpost + 1);
                    realData[4] = rs1.getString(12).getBytes();
                    realData[5] = rs1.getString(10).getBytes();
                    realData[6] = rs1.getString(8).getBytes();
                    f = rs1.getString(5).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 1;
                            break;
                        }
                    }
                    f = rs1.getString(6).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 1;
                            break;
                        }
                    }
                    realData[11] = rs1.getString(3).getBytes();
                    realData[12] = rs1.getString(1).getBytes();
                    realData[13] = new byte[2];
                    realData[13][0] = 0;
                    realData[13][1] = 5;
                    String p1 = fColumn.substring(0, post);
                    fColumn = fColumn.substring(post + 1);
                    realData[7] = p1.getBytes();
                    realData[8] = new byte[2];
                    realData[8][0] = (byte)((i & 0xFF00) >> 8);
                    realData[8][1] = (byte)(i & 0xFF);
                    i = (short)(i + 1);
                    rowData.addRow((byte[][])realData);
                    realData = null;
                }
                realData = new byte[14][];
                realData[0] = rs1.getString(11).getBytes();
                realData[1] = rs1.getString(9).getBytes();
                realData[2] = rs1.getString(7).getBytes();
                realData[3] = pColumn.substring(0).getBytes();
                realData[4] = rs1.getString(12).getBytes();
                realData[5] = rs1.getString(10).getBytes();
                realData[6] = rs1.getString(8).getBytes();
                f = rs1.getString(5).charAt(0);
                switch (f) {
                    case 110: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(6).charAt(0);
                switch (f) {
                    case 110: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 1;
                        break;
                    }
                }
                realData[11] = rs1.getString(3).getBytes();
                realData[12] = rs1.getString(1).getBytes();
                realData[13] = new byte[2];
                realData[13][0] = 0;
                realData[13][1] = 5;
                fColumn = fColumn.substring(0);
                realData[7] = fColumn.getBytes();
                realData[8] = new byte[2];
                realData[8][0] = (byte)((i & 0xFF00) >> 8);
                realData[8][1] = (byte)(i & 0xFF);
                rowData.addRow((byte[][])realData);
                realData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1 = null;
        stm = null;
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTypeInfo");
        }
        java.sql.ResultSet rs = null;
        ResultSet rs1 = null;
        Connection conn = this.connection;
        Statement stm = (Statement)conn.createStatement();
        Field[] filed = new Field[]{new Field("TYPE_NAME", 30, 30, 1, this.curr_db), new Field("DATA_TYPE", 5, 4, 1, this.curr_db), new Field("PRECISION", 5, 4, 1, this.curr_db), new Field("LITERAL_PREFIX", 30, 10, 1, this.curr_db), new Field("LITERAL_SUFFIX", 30, 10, 1, this.curr_db), new Field("CREATE_PARAMS", 30, 10, 1, this.curr_db), new Field("NULLABLE", 4, 2, 1, this.curr_db), new Field("CASE_SENSITIVE", 2, 1, 1, this.curr_db), new Field("SEARCHABLE", 4, 2, 1, this.curr_db), new Field("UNSIGNED_ATTRIBUTE", 2, 1, 1, this.curr_db), new Field("FIXED_PREC_SCALE", 2, 1, 1, this.curr_db), new Field("AUTO_INCREMENT", 2, 1, 1, this.curr_db), new Field("LOCAL_TYPE_NAME", 30, 30, 1, this.curr_db), new Field("MINIMUM_SCALE", 4, 2, 1, this.curr_db), new Field("MAXIMUM_SCALE", 4, 2, 1, this.curr_db), new Field("SQL_DATA_TYPE", 5, 4, 1, this.curr_db), new Field("SQL_DATETIME_SUB", 5, 4, 1, this.curr_db), new Field("NUM_PREC_RADIX", 5, 4, 1, this.curr_db)};
        Vector array = new Vector();
        RowData rdata = new RowData(array);
        rs1 = new ResultSet(conn, stm, this.curr_db, filed, rdata, null);
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getTypeInfo");
        String sql = this.messageFormat.format(null);
        rs = stm.executeQuery(sql);
        int type_num = 0;
        while (rs.next()) {
            Object rowData = new byte[18][];
            String typeName = null;
            int precision = 0;
            typeName = rs.getString(1);
            if (typeName == null) continue;
            rowData[0] = typeName.getBytes();
            type_num = TypesUtil.toJavaType(TypesUtil.getRedhorseType(typeName));
            rowData[1] = new byte[4];
            rowData[1][0] = (byte)((type_num & 0xFF000000) >> 24);
            rowData[1][1] = (byte)((type_num & 0xFF0000) >> 16);
            rowData[1][2] = (byte)((type_num & 0xFF00) >> 8);
            rowData[1][3] = (byte)(type_num & 0xFF);
            if (typeName.equalsIgnoreCase("char") || typeName.equalsIgnoreCase("varchar")) {
                precision = 65536;
            }
            if (typeName.equalsIgnoreCase("numeric")) {
                precision = 38;
            }
            if (typeName.equalsIgnoreCase("time")) {
                precision = 8;
            }
            if (typeName.equalsIgnoreCase("date")) {
                precision = 10;
            }
            if (typeName.equalsIgnoreCase("datetime")) {
                precision = 20;
            }
            if (typeName.equalsIgnoreCase("boolean")) {
                precision = 1;
            }
            if (typeName.equalsIgnoreCase("time")) {
                precision = 8;
            }
            if (typeName.equalsIgnoreCase("date")) {
                precision = 10;
            }
            if (typeName.equalsIgnoreCase("datetime")) {
                precision = 20;
            }
            if (typeName.equalsIgnoreCase("rowid")) {
                precision = 16;
            }
            rowData[2] = new byte[4];
            rowData[2][0] = (byte)((precision & 0xFF000000) >> 24);
            rowData[2][1] = (byte)((precision & 0xFF0000) >> 16);
            rowData[2][2] = (byte)((precision & 0xFF00) >> 8);
            rowData[2][3] = (byte)(precision & 0xFF);
            rowData[3] = null;
            rowData[4] = null;
            rowData[5] = null;
            rowData[6] = new byte[2];
            rowData[6][0] = 0;
            rowData[6][1] = 1;
            rowData[7] = typeName.equalsIgnoreCase("char") || typeName.equalsIgnoreCase("varchar") ? String.valueOf(true).getBytes() : String.valueOf(false).getBytes();
            if (typeName.equalsIgnoreCase("blob") || typeName.equalsIgnoreCase("clob") || typeName.equalsIgnoreCase("binary") || typeName.equalsIgnoreCase("image")) {
                rowData[8] = new byte[2];
                rowData[8][0] = 0;
                rowData[8][1] = 0;
            } else {
                rowData[8] = new byte[2];
                rowData[8][0] = 0;
                rowData[8][1] = 3;
            }
            if (typeName.equalsIgnoreCase("tinyint") || typeName.equalsIgnoreCase("smallint") || typeName.equalsIgnoreCase("integer") || typeName.equalsIgnoreCase("bigint") || typeName.equalsIgnoreCase("float") || typeName.equalsIgnoreCase("double") || typeName.equalsIgnoreCase("numeric")) {
                rowData[9] = String.valueOf(false).getBytes();
                rowData[10] = String.valueOf(true).getBytes();
            } else {
                rowData[9] = String.valueOf(true).getBytes();
                rowData[10] = String.valueOf(false).getBytes();
            }
            rowData[11] = typeName.equalsIgnoreCase("integer") || typeName.equalsIgnoreCase("bigint") ? String.valueOf(true).getBytes() : String.valueOf(false).getBytes();
            rowData[12] = null;
            if (typeName.equalsIgnoreCase("numeric")) {
                rowData[13] = new byte[2];
                rowData[13][0] = 0;
                rowData[13][1] = 0;
                rowData[14] = new byte[2];
                rowData[14][0] = 0;
                rowData[14][1] = 63;
            }
            rowData[15] = null;
            rowData[16] = null;
            if (typeName.equalsIgnoreCase("float") || typeName.equalsIgnoreCase("double")) {
                rowData[17] = new byte[4];
                rowData[17][0] = 0;
                rowData[17][1] = 0;
                rowData[17][2] = 0;
                rowData[17][3] = 2;
            } else if (typeName.equalsIgnoreCase("numeric")) {
                rowData[17] = new byte[4];
                rowData[17][0] = 0;
                rowData[17][1] = 0;
                rowData[17][2] = 0;
                rowData[17][3] = 10;
            }
            try {
                rs1.addRow((byte[][])rowData);
                rowData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs = null;
        stm = null;
        rs1.setRsIsOver(true);
        rs1.setManificateRs(true);
        return rs1;
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getIndexInfo  " + catalog + " , " + schema + " , " + table + " , " + unique + " , " + approximate);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        java.sql.ResultSet rs2 = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        String sql = "";
        String index_key = "";
        Statement stm = (Statement)this.connection.createStatement();
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("TABLE_CAT", 30, 30, 1, real_catalog), new Field("TABLE_SCHEM", 30, 30, 1, real_catalog), new Field("TABLE_NAME", 30, 30, 1, real_catalog), new Field("NON_UNIQUE", 2, 1, 1, real_catalog), new Field("INDEX_QUALIFIER", 30, 10, 1, real_catalog), new Field("INDEX_NAME", 30, 20, 1, real_catalog), new Field("TYPE", 4, 2, 1, real_catalog), new Field("ORDINAL_POSITION", 4, 2, 1, real_catalog), new Field("COLUMN_NAME", 30, 20, 1, real_catalog), new Field("ASC_OR_DESC", 30, 1, 1, real_catalog), new Field("CARDINALITY", 5, 4, 1, real_catalog), new Field("PAGES", 5, 4, 1, real_catalog), new Field("FILTER_CONDITION", 30, 20, 1, real_catalog)};
        Object[] indexObj = null;
        Vector array = new Vector();
        RowData rd = new RowData(array);
        rs = new ResultSet(this.connection, stm, catalog, field, rd, null);
        if (table.equals("%")) {
            if (unique) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%Unique");
                indexObj = new Object[]{real_schema, unique};
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%");
                indexObj = new Object[]{real_schema};
            }
        } else if (unique) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoUnique");
            indexObj = new Object[]{real_schema, unique, "'" + table + "'"};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo");
            indexObj = new Object[]{real_schema, "'" + table + "'"};
        }
        sql = this.messageFormat.format(indexObj);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            try {
                byte[][] rowData = new byte[13][];
                rowData[0] = real_catalog.getBytes();
                rowData[1] = rs1.getString("SCHEMA_NAME").getBytes(this.connection.getCharSet());
                rowData[2] = rs1.getString("TABLE_NAME").getBytes(this.connection.getCharSet());
                char c = rs1.getString("IS_UNIQUE").charAt(0);
                rowData[3] = c == 'f' || c == 'F' ? String.valueOf("T").getBytes() : String.valueOf("F").getBytes();
                int i = rs1.getInt("INDEX_TYPE");
                switch (i) {
                    case 0: {
                        rowData[4] = new String("B\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 1: {
                        rowData[4] = new String("R\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 2: {
                        rowData[4] = new String("\u5168\u6587\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                }
                rowData[5] = rs1.getString("INDEX_NAME").getBytes(this.connection.getCharSet());
                rowData[6] = new byte[2];
                rowData[6][0] = 0;
                rowData[6][1] = 3;
                rowData[9] = null;
                index_key = rs1.getString("KEYS");
                int total = 0;
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoMore");
                Object[] more = new Object[]{rs1.getString("SCHEMA_NAME"), rs1.getString("TABLE_NAME")};
                String sql2 = this.messageFormat.format(more);
                rs2 = stm.executeQuery(sql2);
                while (rs2.next()) {
                    total = rs2.getInt(1);
                }
                rowData[10] = new byte[4];
                rowData[10][0] = (byte)((total & 0xFF000000) >> 24);
                rowData[10][1] = (byte)((total & 0xFF0000) >> 16);
                rowData[10][2] = (byte)((total & 0xFF00) >> 8);
                rowData[10][3] = (byte)(total & 0xFF);
                rowData[11] = new byte[4];
                rowData[11][0] = 0;
                rowData[11][1] = 0;
                rowData[11][2] = 0;
                rowData[11][3] = 1;
                rowData[12] = null;
                rowData[7] = new byte[2];
                int post = 0;
                int squ = 1;
                try {
                    while ((post = index_key.indexOf(44)) != -1) {
                        byte[][] row = new byte[13][];
                        System.arraycopy(rowData, 0, row, 0, 7);
                        row[8] = index_key.substring(0, post).getBytes();
                        index_key = index_key.substring(post + 1);
                        row[7] = new byte[2];
                        row[7][0] = (byte)((squ & 0xFF00) >> 8);
                        row[7][1] = (byte)(squ & 0xFF);
                        System.arraycopy(rowData, 9, row, 9, 4);
                        rs.addRow(row);
                        squ = (short)(squ + 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                rowData[8] = index_key.getBytes(this.connection.getCharSet());
                rowData[7][0] = (byte)((squ & 0xFF00) >> 8);
                rowData[7][1] = (byte)(squ & 0xFF);
                try {
                    rs.addRow(rowData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw SQLCommon.EncodingException(e1);
            }
        }
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        stm.close();
        rs1 = null;
        rs2 = null;
        return rs;
    }

    public java.sql.ResultSet getIndexInfoXuGu(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getIndexInfo  " + catalog + " , " + schema + " , " + table + " , " + unique + " , " + approximate);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        java.sql.ResultSet rs2 = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        String sql = "";
        String index_key = "";
        Statement stm = (Statement)this.connection.createStatement();
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("TABLE_CAT", 30, 30, 1, real_catalog), new Field("TABLE_SCHEM", 30, 30, 1, real_catalog), new Field("TABLE_NAME", 30, 30, 1, real_catalog), new Field("NON_UNIQUE", 2, 1, 1, real_catalog), new Field("INDEX_QUALIFIER", 30, 10, 1, real_catalog), new Field("INDEX_NAME", 30, 20, 1, real_catalog), new Field("TYPE", 4, 2, 1, real_catalog), new Field("ORDINAL_POSITION", 4, 2, 1, real_catalog), new Field("COLUMN_NAME", 30, 20, 1, real_catalog), new Field("ASC_OR_DESC", 30, 1, 1, real_catalog), new Field("CARDINALITY", 5, 4, 1, real_catalog), new Field("PAGES", 5, 4, 1, real_catalog), new Field("FILTER_CONDITION", 30, 20, 1, real_catalog), new Field("IS_LOCAL", 2, 1, 1, real_catalog)};
        Object[] indexObj = null;
        Vector array = new Vector();
        RowData rd = new RowData(array);
        rs = new ResultSet(this.connection, stm, catalog, field, rd, null);
        if (table.equals("%")) {
            if (unique) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%Unique");
                indexObj = new Object[]{real_schema, unique};
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%");
                indexObj = new Object[]{real_schema};
            }
        } else if (unique) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoUnique");
            indexObj = new Object[]{real_schema, unique, "'" + table + "'"};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo");
            indexObj = new Object[]{real_schema, "'" + table + "'"};
        }
        sql = this.messageFormat.format(indexObj);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            try {
                byte[][] rowData = new byte[14][];
                rowData[0] = real_catalog.getBytes();
                rowData[1] = rs1.getString("SCHEMA_NAME").getBytes(this.connection.getCharSet());
                rowData[2] = rs1.getString("TABLE_NAME").getBytes(this.connection.getCharSet());
                char c = rs1.getString("IS_UNIQUE").charAt(0);
                rowData[3] = c == 'f' || c == 'F' ? String.valueOf("T").getBytes() : String.valueOf("F").getBytes();
                int i = rs1.getInt("INDEX_TYPE");
                switch (i) {
                    case 0: {
                        rowData[4] = new String("B\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 1: {
                        rowData[4] = new String("R\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 2: {
                        rowData[4] = new String("\u5168\u6587\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                }
                rowData[5] = rs1.getString("INDEX_NAME").getBytes(this.connection.getCharSet());
                rowData[6] = new byte[2];
                rowData[6][0] = 0;
                rowData[6][1] = 3;
                rowData[9] = null;
                index_key = rs1.getString("KEYS");
                int total = 0;
                char is_local = rs1.getString("IS_LOCAL").charAt(0);
                rowData[13] = is_local == 'f' || is_local == 'F' ? "F".getBytes() : "T".getBytes();
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoMore");
                Object[] more = new Object[]{rs1.getString("SCHEMA_NAME"), rs1.getString("TABLE_NAME")};
                String sql2 = this.messageFormat.format(more);
                rs2 = stm.executeQuery(sql2);
                while (rs2.next()) {
                    total = rs2.getInt(1);
                }
                rowData[10] = new byte[4];
                rowData[10][0] = (byte)((total & 0xFF000000) >> 24);
                rowData[10][1] = (byte)((total & 0xFF0000) >> 16);
                rowData[10][2] = (byte)((total & 0xFF00) >> 8);
                rowData[10][3] = (byte)(total & 0xFF);
                rowData[11] = new byte[4];
                rowData[11][0] = 0;
                rowData[11][1] = 0;
                rowData[11][2] = 0;
                rowData[11][3] = 1;
                rowData[12] = null;
                rowData[7] = new byte[2];
                rowData[8] = index_key.getBytes(this.connection.getCharSet());
                rowData[7][0] = 0;
                rowData[7][1] = 1;
                try {
                    rs.addRow(rowData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw SQLCommon.EncodingException(e1);
            }
        }
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        stm.close();
        rs1 = null;
        rs2 = null;
        return rs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetType");
        }
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetConcurrency   " + type + " , " + concurrency);
        }
        boolean flag = type == 1003 && concurrency == 1007 || type == 1004 && concurrency == 1007 || type == 1005 && concurrency == 1008;
        return flag;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownUpdatesAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownDeletesAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownInsertsAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersUpdatesAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersDeletesAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersInsertsAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "updatesAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "deletesAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "insertsAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50067, 50067);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsBatchUpdates");
        }
        return true;
    }

    @Override
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (Command.debug) {
            String typesStr = "";
            if (types != null && types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    typesStr = i == types.length ? typesStr + types[i] : typesStr + types[i] + ",";
                }
            }
            Command.logDMmethods(this.connection.io, "getUDTs   " + catalog + " , " + schemaPattern + " , " + typeNamePattern + " , " + typesStr);
        }
        java.sql.ResultSet rs = null;
        String sp1 = null;
        String sp2 = null;
        String sql = null;
        String[] udtObj = null;
        int sepInt = 0;
        Statement stm = (Statement)this.connection.createStatement(false);
        if (typeNamePattern == null) {
            typeNamePattern = "%";
        }
        if ((sepInt = typeNamePattern.indexOf(".")) != -1) {
            sp1 = typeNamePattern.substring(0, sepInt);
            typeNamePattern = typeNamePattern.substring(sepInt + 1);
        }
        if ((sepInt = typeNamePattern.indexOf(".")) != -1) {
            sp2 = typeNamePattern.substring(0, sepInt);
            typeNamePattern = typeNamePattern.substring(sepInt + 1);
        }
        if (sp2 != null) {
            catalog = sp1;
            schemaPattern = sp2;
        }
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String inSql = "";
        String ininSql = "";
        int in = 0;
        if (types != null) {
            block9: for (int j = 0; j < types.length; ++j) {
                if (in == 0) {
                    if (types[j] != 2002 && types[j] != 2001) continue;
                    ++in;
                    switch (types[j]) {
                        case 2002: {
                            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTsIn1");
                            break;
                        }
                        case 2001: {
                            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTsIn2");
                            break;
                        }
                    }
                    continue;
                }
                switch (types[j]) {
                    case 2002: {
                        ininSql = ininSql + " or UDT_TYPE in(1001,1005)";
                        continue block9;
                    }
                    case 2001: {
                        ininSql = ininSql + " or UDT_TYPE =1005";
                        continue block9;
                    }
                }
            }
            if (in > 0) {
                inSql = this.messageFormat.format(new String[]{ininSql});
            }
        }
        if (typeNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTs%");
            udtObj = new String[]{"'" + this.curr_db + "'", String.valueOf(2002), String.valueOf(2002), String.valueOf(2001), String.valueOf(2001), real_schema, inSql};
            sql = this.messageFormat.format(udtObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTs");
            udtObj = new String[]{"'" + this.curr_db + "'", String.valueOf(2002), String.valueOf(2002), String.valueOf(2001), String.valueOf(2001), real_schema, "'" + typeNamePattern + "'", inSql};
            sql = this.messageFormat.format(udtObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getConnection");
        }
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSavepoints");
        }
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsNamedParameters");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleOpenResults");
        }
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGetGeneratedKeys");
        }
        return true;
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSuperTypes   " + catalog + " , " + schemaPattern + " , " + typeNamePattern);
        }
        java.sql.ResultSet rs = null;
        String sql = null;
        String[] sTypesObj = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        if (typeNamePattern == null) {
            typeNamePattern = "%";
        }
        if (typeNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSuperTypes%");
            sTypesObj = new String[]{"'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", real_schema};
            sql = this.messageFormat.format(sTypesObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSuperTypes");
            sTypesObj = new String[]{"'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", real_schema, "'" + typeNamePattern + "'"};
            sql = this.messageFormat.format(sTypesObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSuperTables\u672a\u5b9e\u73b0  ");
        }
        throw SQLCommon.unSupportException("DatabaseMetadata.getSuperTables", "String,String.String");
    }

    @Override
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getAttributes   " + catalog + " , " + schemaPattern + " , " + typeNamePattern + " , " + attributeNamePattern);
        }
        this.checkConnectionOpen();
        java.sql.ResultSet rs = null;
        Object[] atrributeObj = null;
        int udtType = 0;
        Statement stm = (Statement)this.connection.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        if (typeNamePattern.equalsIgnoreCase("object")) {
            udtType = 1001;
        }
        if (typeNamePattern.equalsIgnoreCase("array")) {
            udtType = 1004;
        }
        if (typeNamePattern.equalsIgnoreCase("table")) {
            udtType = 1005;
        }
        if ((typeNamePattern == null || typeNamePattern.equals("%")) && (attributeNamePattern == null || attributeNamePattern.equals("%"))) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeNameAndType%"));
        } else if (typeNamePattern == null || typeNamePattern.equals("%")) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, "'" + attributeNamePattern + "'"};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeType%"));
        } else if (attributeNamePattern == null || attributeNamePattern.equals("%")) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, String.valueOf(udtType)};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeName%"));
        } else {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, "'" + attributeNamePattern + "'", String.valueOf(udtType)};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttribute"));
        }
        String sql = this.messageFormat.format(atrributeObj);
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetHoldability");
        }
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getResultSetHoldability");
        }
        return this.connection.RsHoldablity;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseMajorVersion");
        }
        String versionStr = this.getDatabaseProductVersion();
        int majorVersion = 0;
        if (this.connection.isora) {
            majorVersion = Integer.valueOf(versionStr);
        } else if (!ReplaceEnum.databaseProductVersion.getReplaceStr().equals("")) {
            int numIndex = this.getNumberIndex(versionStr);
            String[] versionNumStrings = versionStr.substring(numIndex).split("\\.");
            majorVersion = Integer.parseInt(versionNumStrings[0]);
        } else {
            majorVersion = versionStr.contains("SQL Server") ? Integer.parseInt(versionStr.substring(versionStr.indexOf(" Server") + 8, versionStr.indexOf("."))) : Integer.parseInt(versionStr.substring(versionStr.indexOf(" ") + 1, versionStr.indexOf(".")));
        }
        return majorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String version;
        String[] versionNumStrings;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseMinorVersion");
        }
        String versionStr = this.getDatabaseProductVersion();
        int minorVersion = 0;
        if (this.connection.isIsora()) {
            return 0;
        }
        minorVersion = !ReplaceEnum.databaseProductVersion.getReplaceStr().equals("") ? ((versionNumStrings = versionStr.split("\\.")).length > 1 ? Integer.parseInt(versionNumStrings[1]) : 0) : ((version = versionStr.substring(versionStr.indexOf(" ") + 1)).indexOf(".") == version.lastIndexOf(".") ? Integer.parseInt(version.substring(version.indexOf(".") + 1)) : Integer.parseInt(version.substring(version.indexOf(".") + 1, version.lastIndexOf("."))));
        return minorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getJDBCMajorVersion");
        }
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getJDBCMinorVersion");
        }
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSQLStateType");
        }
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "locatorsUpdateCopy");
        }
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStatementPooling");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getVersionColumns\u672a\u5b9e\u73b0   " + catalog + " , " + schema + " , " + table);
        }
        throw SQLCommon.unSupportException("DatabaseMetadata.getVersionColumns", "String,String.String");
    }

    /*
     * Exception decompiling
     */
    @Override
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getImportedKeys   " + catalog + " , " + schema + " , " + table);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String sql = null;
        Statement stm = (Statement)this.connection.createStatement();
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        int f = 32;
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("KEY_SEQ", 4, 2, 1, real_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_catalog), new Field("DELETE_RULE", 4, 2, 1, real_catalog), new Field("FK_NAME", 30, 20, 1, real_catalog), new Field("PK_NAME", 30, 20, 1, real_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_catalog)};
        Vector array = new Vector();
        Object[] imortObject = null;
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, catalog, field, rowData, null);
        if (table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getImportedKeys%");
            imortObject = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema, real_schema};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getImportedKeys");
            imortObject = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", "'" + table + "'", real_schema, real_schema};
        }
        sql = this.messageFormat.format(imortObject);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            Object data;
            int i = 1;
            int post = 0;
            String fColumn = null;
            String f_kColumns = rs1.getString(2);
            fColumn = this.trimString(f_kColumns);
            while ((post = fColumn.indexOf(",")) != -1) {
                data = new byte[14][];
                data[0] = rs1.getString(12).getBytes();
                data[1] = rs1.getString(7).getBytes();
                data[2] = rs1.getString(8).getBytes();
                data[3] = rs1.getString(6).getBytes();
                data[4] = rs1.getString(11).getBytes();
                data[5] = rs1.getString(10).getBytes();
                data[6] = rs1.getString(9).getBytes();
                f = rs1.getString(3).charAt(0);
                switch (f) {
                    case 78: 
                    case 110: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 3;
                        break;
                    }
                    case 67: 
                    case 99: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 0;
                        break;
                    }
                    case 85: 
                    case 117: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 2;
                        break;
                    }
                    case 68: 
                    case 100: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 4;
                        break;
                    }
                    case 82: 
                    case 114: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(4).charAt(0);
                switch (f) {
                    case 78: 
                    case 110: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 3;
                        break;
                    }
                    case 67: 
                    case 99: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 0;
                        break;
                    }
                    case 85: 
                    case 117: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 2;
                        break;
                    }
                    case 68: 
                    case 100: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 4;
                        break;
                    }
                    case 82: 
                    case 114: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 1;
                        break;
                    }
                }
                data[11] = rs1.getString(1).getBytes();
                data[12] = rs1.getString(5).getBytes();
                data[13] = new byte[2];
                data[13][0] = 0;
                data[13][1] = 5;
                data[7] = fColumn.substring(0, post).getBytes();
                fColumn = fColumn.substring(post + 1);
                data[8] = new byte[2];
                data[8][0] = (byte)((i & 0xFF00) >> 8);
                data[8][1] = (byte)(i & 0xFF);
                i = (short)(i + 1);
                try {
                    rs.addRow((byte[][])data);
                    data = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            data = new byte[14][];
            data[0] = rs1.getString(12).getBytes();
            data[1] = rs1.getString(7).getBytes();
            data[2] = rs1.getString(8).getBytes();
            data[3] = rs1.getString(6).getBytes();
            data[4] = rs1.getString(11).getBytes();
            data[5] = rs1.getString(10).getBytes();
            data[6] = rs1.getString(9).getBytes();
            f = rs1.getString(3).charAt(0);
            switch (f) {
                case 78: 
                case 110: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 3;
                    break;
                }
                case 67: 
                case 99: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 0;
                    break;
                }
                case 85: 
                case 117: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 2;
                    break;
                }
                case 68: 
                case 100: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 4;
                    break;
                }
                case 82: 
                case 114: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 1;
                    break;
                }
            }
            f = rs1.getString(4).charAt(0);
            switch (f) {
                case 78: 
                case 110: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 3;
                    break;
                }
                case 67: 
                case 99: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 0;
                    break;
                }
                case 85: 
                case 117: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 2;
                    break;
                }
                case 68: 
                case 100: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 4;
                    break;
                }
                case 82: 
                case 114: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 1;
                    break;
                }
            }
            data[11] = rs1.getString(1).getBytes();
            data[12] = rs1.getString(5).getBytes();
            data[13] = new byte[2];
            data[13][0] = 0;
            data[13][1] = 5;
            data[7] = fColumn.substring(0).getBytes();
            fColumn = fColumn.substring(post + 1);
            data[8] = new byte[2];
            data[8][0] = (byte)((i & 0xFF00) >> 8);
            data[8][1] = (byte)(i & 0xFF);
            i = (short)(i + 1);
            try {
                rs.addRow((byte[][])data);
                data = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1.close();
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "autoCommitFailureClosesAllResultSets");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getClientInfoProperties");
        }
        String catalog = this.getRealCatalog("");
        Properties clientInfo = this.connection.getClientInfo();
        Field[] field = new Field[]{new Field("NAME", 30, 50, 1, catalog), new Field("MAX_LEN", 5, 4, 1, catalog), new Field("DEFAULT_VALUE", 30, 50, 1, catalog), new Field("DESCRIPTION", 30, 100, 1, catalog)};
        Vector<byte[][]> clientArray = new Vector<byte[][]>();
        RowData clientRowData = new RowData(clientArray);
        Statement stm = (Statement)this.connection.createStatement();
        ResultSet cliengRs = new ResultSet(this.connection, stm, catalog, field, clientRowData, null);
        Enumeration<?> en = clientInfo.propertyNames();
        while (en.hasMoreElements()) {
            byte[][] clientBytes = new byte[4][];
            String strKey = (String)en.nextElement();
            String strValue = clientInfo.getProperty(strKey);
            clientBytes[0] = strKey.getBytes();
            clientBytes[1] = new byte[4];
            clientBytes[1][3] = 0;
            clientBytes[1][2] = 0;
            clientBytes[1][1] = 0;
            clientBytes[1][0] = 50;
            clientBytes[2] = strValue.getBytes();
            clientBytes[3] = "".getBytes();
            clientArray.add(clientBytes);
        }
        stm.close();
        cliengRs.setRsIsOver(true);
        cliengRs.setManificateRs(true);
        return cliengRs;
    }

    @Override
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getFunctionColumns\u672a\u5b9e\u73b0        " + catalog + " , " + schemaPattern + " , " + functionNamePattern + " , " + columnNamePattern);
        }
        throw SQLCommon.unSupportException("DatabaseMetadata.getFunctionColumns", "String,String.String,String");
    }

    @Override
    public java.sql.ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getFunctions   " + catalog + " , " + schemaPattern + " , " + functionNamePattern);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String sql = null;
        String[] funObj = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (functionNamePattern == null) {
            functionNamePattern = "%";
        }
        if (!functionNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getFunctions");
            funObj = new String[]{"'" + this.curr_db + "'", "'1'", "'1'", "'2'", "'" + functionNamePattern + "'", real_schema};
            sql = this.messageFormat.format(funObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getFunctions%");
            funObj = new String[]{"'" + this.curr_db + "'", "'1'", "'1'", "'2'", real_schema};
            sql = this.messageFormat.format(funObj);
        }
        String sql1 = null;
        sql1 = functionNamePattern.equals("%") ? SQLCommon.getMessageFormat("DatabaseMetadata.getFunctionsSys%").format(null) : SQLCommon.getMessageFormat("DatabaseMetadata.getFunctionsSys").format(new String[]{"'" + functionNamePattern + "'"});
        rs = (ResultSet)stm.executeQuery(sql);
        rs1 = stm.executeQuery(sql1);
        int i = 1;
        while (rs1.next()) {
            String name = rs1.getString(1);
            Object data = new byte[17][];
            data[0] = "SYSTEM".getBytes();
            data[1] = "SYSDBA".getBytes();
            data[2] = name.getBytes();
            data[3] = "System function".getBytes();
            data[4] = new byte[2];
            data[4][0] = 0;
            data[4][1] = 0;
            data[5] = (name + "_" + i).getBytes();
            ++i;
            try {
                rs.addRow((byte[][])data);
                data = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rs1.close();
        stm.close();
        sql = null;
        sql1 = null;
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        java.sql.ResultSet rs = null;
        String sql = null;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSchemas   " + catalog + " , " + schemaPattern);
        }
        Statement stm = (Statement)this.connection.createStatement(false);
        if (schemaPattern == null) {
            schemaPattern = "%";
        } else if (schemaPattern.equals("")) {
            schemaPattern = this.curr_user;
        }
        if (schemaPattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemasPram%");
            Object[] sParam = new Object[]{"'" + this.curr_db + "'"};
            sql = this.messageFormat.format(sParam);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemasPram");
            Object[] sParam = new Object[]{"'" + this.curr_db + "'", "'" + schemaPattern + "'"};
            sql = this.messageFormat.format(sParam);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStoredFunctionsUsingCallSyntax");
        }
        return true;
    }

    private String trimString(String temp) {
        String pColumn = null;
        pColumn = temp.indexOf("(") != -1 ? temp.substring(temp.indexOf("(") + 1, temp.indexOf(")")) : temp;
        return pColumn;
    }

    private String getTableRealType(java.sql.Statement stm, String objName, String objSchema) throws SQLException {
        java.sql.ResultSet rs = null;
        String type = null;
        if (objName != null && objName.equals("%")) {
            return "TABLE";
        }
        if (objName == null) {
            objName = "%";
        }
        String sql = this.useLike != false || objName.equalsIgnoreCase("%") ? SQLCommon.getMessageFormat("DatabaseMetadata.getTableRealTypeLike").format(new String[]{objSchema, "'" + objName + "'"}) : SQLCommon.getMessageFormat("DatabaseMetadata.getTableRealType").format(new String[]{objSchema, "'" + objName + "'"});
        rs = stm.executeQuery(sql);
        type = rs.next() ? "TABLE" : "VIEW";
        rs.close();
        rs = null;
        return type;
    }

    private String rsToString(java.sql.ResultSet rs) throws SQLException {
        StringBuffer allString = new StringBuffer();
        int i = 0;
        allString.append("'");
        while (rs.next()) {
            if (i == 0) {
                allString.append(rs.getString(1));
            } else {
                allString.append("','");
                allString.append(rs.getString(1));
            }
            ++i;
        }
        allString.append("'");
        return allString.toString();
    }

    private String getRealSchemas(String catalog, String schema) throws SQLException {
        this.checkConnectionOpen();
        if (schema != null && !schema.equals("%") && !schema.equals("")) {
            return "'" + schema + "'";
        }
        try {
            java.sql.ResultSet schemaRs = this.getSchemas(catalog, schema);
            this.schemaString = this.rsToString(schemaRs);
            schemaRs.close();
            schemaRs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.schemaString;
    }

    private String getRealCatalog(String catalog) {
        return this.curr_db;
    }

    private void checkConnectionOpen() throws SQLException {
        this.connection.checkOpen();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    private int getNumberIndex(String findStr) {
        int index;
        char[] findChars = findStr.toCharArray();
        for (index = 0; index < findChars.length && !Character.isDigit(findChars[index]); ++index) {
        }
        return index;
    }
}

