/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.io.PrintStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentPointComparator;

public class SegmentNode
implements Comparable {
    private final NodedSegmentString segString;
    public final Coordinate coord;
    public final int segmentIndex;
    private final int segmentOctant;
    private final boolean isInterior;

    public SegmentNode(NodedSegmentString segString, Coordinate coord, int segmentIndex, int segmentOctant) {
        this.segString = segString;
        this.coord = new Coordinate(coord);
        this.segmentIndex = segmentIndex;
        this.segmentOctant = segmentOctant;
        this.isInterior = !coord.equals2D(segString.getCoordinate(segmentIndex));
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public boolean isInterior() {
        return this.isInterior;
    }

    public boolean isEndPoint(int maxSegmentIndex) {
        if (this.segmentIndex == 0 && !this.isInterior) {
            return true;
        }
        return this.segmentIndex == maxSegmentIndex;
    }

    public int compareTo(Object obj) {
        SegmentNode other = (SegmentNode)obj;
        if (this.segmentIndex < other.segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > other.segmentIndex) {
            return 1;
        }
        if (this.coord.equals2D(other.coord)) {
            return 0;
        }
        return SegmentPointComparator.compare(this.segmentOctant, this.coord, other.coord);
    }

    public void print(PrintStream out) {
        out.print(this.coord);
        out.print(" seg # = " + this.segmentIndex);
    }
}

