/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public abstract class BinaryExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression leftExpression;
    private Expression rightExpression;

    public BinaryExpression() {
    }

    public BinaryExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    public static Expression build(Class<? extends BinaryExpression> clz, Expression ... expressions) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        switch (expressions.length) {
            case 0: {
                return new NullValue();
            }
            case 1: {
                return expressions[0];
            }
        }
        Iterator it = Arrays.stream(expressions).iterator();
        Expression leftExpression = (Expression)it.next();
        Expression rightExpression = (Expression)it.next();
        BinaryExpression binaryExpression = clz.getConstructor(Expression.class, Expression.class).newInstance(leftExpression, rightExpression);
        while (it.hasNext()) {
            rightExpression = (Expression)it.next();
            binaryExpression = clz.getConstructor(Expression.class, Expression.class).newInstance(binaryExpression, rightExpression);
        }
        return binaryExpression;
    }

    public static Expression add(Expression ... expressions) {
        try {
            return BinaryExpression.build(Addition.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression bitAnd(Expression ... expressions) {
        try {
            return BinaryExpression.build(BitwiseAnd.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression bitShiftLeft(Expression ... expressions) {
        try {
            return BinaryExpression.build(BitwiseLeftShift.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression multiply(Expression ... expressions) {
        try {
            return BinaryExpression.build(Multiplication.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression bitOr(Expression ... expressions) {
        try {
            return BinaryExpression.build(BitwiseOr.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression bitShiftRight(Expression ... expressions) {
        try {
            return BinaryExpression.build(BitwiseRightShift.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression bitXor(Expression ... expressions) {
        try {
            return BinaryExpression.build(BitwiseXor.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression concat(Expression ... expressions) {
        try {
            return BinaryExpression.build(Concat.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression divide(Expression ... expressions) {
        try {
            return BinaryExpression.build(Division.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression divideInt(Expression ... expressions) {
        try {
            return BinaryExpression.build(IntegerDivision.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression modulo(Expression ... expressions) {
        try {
            return BinaryExpression.build(Modulo.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression subtract(Expression ... expressions) {
        try {
            return BinaryExpression.build(Subtraction.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression or(Expression ... expressions) {
        try {
            return BinaryExpression.build(OrExpression.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression xor(Expression ... expressions) {
        try {
            return BinaryExpression.build(XorExpression.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression and(Expression ... expressions) {
        try {
            return BinaryExpression.build(AndExpression.class, expressions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public BinaryExpression withLeftExpression(Expression expression) {
        this.setLeftExpression(expression);
        return this;
    }

    public BinaryExpression withRightExpression(Expression expression) {
        this.setRightExpression(expression);
        return this;
    }

    public String toString() {
        return this.getLeftExpression() + " " + this.getStringExpression() + " " + this.getRightExpression();
    }

    public abstract String getStringExpression();

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getLeftExpression()));
    }

    public <E extends Expression> E getRightExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getRightExpression()));
    }
}

