/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceNumberValidator {
    private static final Log LOG = LogFactory.getLog(SequenceNumberValidator.class);
    private IKinesisProxy proxy;
    private String shardId;
    private boolean validateWithGetIterator;
    private static final int SERVER_SIDE_ERROR_CODE = 500;

    SequenceNumberValidator(IKinesisProxy proxy, String shardId, boolean validateWithGetIterator) {
        this.proxy = proxy;
        this.shardId = shardId;
        this.validateWithGetIterator = validateWithGetIterator;
    }

    void validateSequenceNumber(String sequenceNumber) throws IllegalArgumentException, ThrottlingException, KinesisClientLibDependencyException {
        boolean atShardEnd = ExtendedSequenceNumber.SHARD_END.getSequenceNumber().equals(sequenceNumber);
        if (!atShardEnd && !SequenceNumberValidator.isDigits(sequenceNumber)) {
            LOG.info((Object)("Sequence number must be numeric, but was " + sequenceNumber));
            throw new IllegalArgumentException("Sequence number must be numeric, but was " + sequenceNumber);
        }
        try {
            if (!atShardEnd && this.validateWithGetIterator) {
                this.proxy.getIterator(this.shardId, ShardIteratorType.AFTER_SEQUENCE_NUMBER.toString(), sequenceNumber);
                LOG.info((Object)("Validated sequence number " + sequenceNumber + " with shard id " + this.shardId));
            }
        }
        catch (InvalidArgumentException e) {
            LOG.info((Object)("Sequence number " + sequenceNumber + " is invalid for shard " + this.shardId), (Throwable)e);
            throw new IllegalArgumentException("Sequence number " + sequenceNumber + " is invalid for shard " + this.shardId, e);
        }
        catch (ProvisionedThroughputExceededException e) {
            LOG.info((Object)("Exceeded throughput while getting an iterator for shard " + this.shardId), (Throwable)e);
            throw new ThrottlingException("Exceeded throughput while getting an iterator for shard " + this.shardId, (Exception)((Object)e));
        }
        catch (AmazonServiceException e) {
            LOG.info((Object)("Encountered service exception while getting an iterator for shard " + this.shardId), (Throwable)e);
            if (e.getStatusCode() >= 500) {
                throw new KinesisClientLibDependencyException("Encountered service exception while getting an iterator for shard " + this.shardId, (Exception)((Object)e));
            }
            throw e;
        }
    }

    void validateSequenceNumber(ExtendedSequenceNumber checkpoint) throws IllegalArgumentException, ThrottlingException, KinesisClientLibDependencyException {
        this.validateSequenceNumber(checkpoint.getSequenceNumber());
        if (checkpoint.getSubSequenceNumber() < 0L) {
            throw new IllegalArgumentException("SubSequence number must be non-negative, but was " + checkpoint.getSubSequenceNumber());
        }
    }

    static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

