/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.concurrent.CountingFutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAbstractCharAsyncEntityConsumer {
    TestAbstractCharAsyncEntityConsumer() {
    }

    @Test
    void testConsumeData() throws Exception {
        StringBuilderAsyncEntityConsumer consumer = new StringBuilderAsyncEntityConsumer();
        CountingFutureCallback countingCallback = new CountingFutureCallback();
        consumer.streamStart((EntityDetails)new BasicEntityDetails(-1L, ContentType.TEXT_PLAIN), countingCallback);
        consumer.consume(ByteBuffer.wrap(new byte[]{49, 50, 51}));
        consumer.consume(ByteBuffer.wrap(new byte[]{52, 53}));
        consumer.consume(ByteBuffer.wrap(new byte[0]));
        Assertions.assertNull((Object)consumer.getContent());
        consumer.streamEnd(null);
        Assertions.assertEquals((Object)"12345", (Object)consumer.getContent());
        Assertions.assertEquals((long)1L, (long)countingCallback.getCount());
    }

    @Test
    void testConsumeIncompleteData() throws Exception {
        StringBuilderAsyncEntityConsumer consumer = new StringBuilderAsyncEntityConsumer();
        CountingFutureCallback countingCallback = new CountingFutureCallback();
        consumer.streamStart((EntityDetails)new BasicEntityDetails(-1L, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)), countingCallback);
        byte[] stuff = "stuff".getBytes(StandardCharsets.UTF_8);
        byte[] splitCharacter = "\u00a3".getBytes(StandardCharsets.UTF_8);
        ByteArrayBuffer b1 = new ByteArrayBuffer(1024);
        b1.append(stuff, 0, stuff.length);
        b1.append(splitCharacter, 0, 1);
        consumer.consume(ByteBuffer.wrap(b1.toByteArray()));
        ByteArrayBuffer b2 = new ByteArrayBuffer(1024);
        b2.append(splitCharacter, 1, 1);
        b2.append(stuff, 0, stuff.length);
        b2.append(splitCharacter, 0, 1);
        consumer.consume(ByteBuffer.wrap(b2.toByteArray()));
        ByteArrayBuffer b3 = new ByteArrayBuffer(1024);
        b3.append(splitCharacter, 1, 1);
        b3.append(stuff, 0, stuff.length);
        consumer.consume(ByteBuffer.wrap(b3.toByteArray()));
        consumer.streamEnd(null);
        Assertions.assertEquals((Object)"stuff\u00a3stuff\u00a3stuff", (Object)consumer.getContent());
        Assertions.assertEquals((long)1L, (long)countingCallback.getCount());
    }

    private static class StringBuilderAsyncEntityConsumer
    extends AbstractCharAsyncEntityConsumer<String> {
        private final StringBuilder buffer = new StringBuilder(1024);

        protected void streamStart(ContentType contentType) throws HttpException, IOException {
        }

        protected int capacityIncrement() {
            return Integer.MAX_VALUE;
        }

        protected void data(CharBuffer src, boolean endOfStream) throws IOException {
            this.buffer.append(src);
        }

        protected String generateContent() throws IOException {
            return this.buffer.toString();
        }

        public void releaseResources() {
            this.buffer.setLength(0);
        }
    }
}

