/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Collection;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public enum Operator implements BinaryOperator<Object>
{
    sum{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.add((Number)a, (Number)b);
        }
    }
    ,
    minus{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.sub((Number)a, (Number)b);
        }
    }
    ,
    mult{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.mul((Number)a, (Number)b);
        }
    }
    ,
    div{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.div((Number)a, (Number)b);
        }
    }
    ,
    min{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.min((Comparable)a, (Comparable)b);
        }
    }
    ,
    max{

        @Override
        public Object apply(Object a, Object b) {
            return NumberHelper.max((Comparable)a, (Comparable)b);
        }
    }
    ,
    assign{

        @Override
        public Object apply(Object a, Object b) {
            return b;
        }
    }
    ,
    and{

        @Override
        public Object apply(Object a, Object b) {
            return (Boolean)a != false && (Boolean)b != false;
        }
    }
    ,
    or{

        @Override
        public Object apply(Object a, Object b) {
            return (Boolean)a != false || (Boolean)b != false;
        }
    }
    ,
    addAll{

        @Override
        public Object apply(Object a, Object b) {
            if (a instanceof Map) {
                ((Map)a).putAll((Map)b);
            } else {
                ((Collection)a).addAll((Collection)b);
            }
            return a;
        }
    }
    ,
    sumLong{

        @Override
        public Object apply(Object a, Object b) {
            return (Long)a + (Long)b;
        }
    };

}

