/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.BfsTraverser;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class StressCentralityAlgorithmV2
extends AbstractCentAlgorithm {
    @Override
    public String name() {
        return "stress_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        super.checkParameters(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.stressCentrality(StressCentralityAlgorithmV2.direction(parameters), StressCentralityAlgorithmV2.edgeLabel(parameters), StressCentralityAlgorithmV2.depth(parameters), StressCentralityAlgorithmV2.degree(parameters), StressCentralityAlgorithmV2.sample(parameters), StressCentralityAlgorithmV2.sourceLabel(parameters), StressCentralityAlgorithmV2.sourceSample(parameters), StressCentralityAlgorithmV2.sourceCLabel(parameters), StressCentralityAlgorithmV2.top(parameters));
            return object;
        }
    }

    private static class StressNode
    extends BfsTraverser.Node {
        private long stress = 0L;

        public StressNode(StressNode parentNode) {
            this(0, parentNode.distance() + 1);
        }

        public StressNode(int pathCount, int distance) {
            super(pathCount, distance);
        }

        public void increaseStress(StressNode childNode) {
            long total = childNode.stress + (long)childNode.pathCount();
            long received = total * (long)this.pathCount() / (long)childNode.pathCount();
            this.stress += received;
        }

        public long stress() {
            return this.stress;
        }
    }

    private static class Traverser
    extends BfsTraverser<StressNode> {
        private Map<Id, MutableLong> globalStresses = new HashMap<Id, MutableLong>();

        private Traverser(UserJob<Object> job) {
            super(job);
        }

        private Object stressCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            Id edgeLabelId = null;
            if (label != null) {
                edgeLabelId = this.graph().edgeLabel(label).id();
            }
            Iterator<Vertex> startVertices = this.vertices(sourceLabel, sourceCLabel, Long.MAX_VALUE);
            while (startVertices.hasNext()) {
                Id startVertex = ((HugeVertex)startVertices.next()).id();
                this.globalStresses.putIfAbsent(startVertex, new MutableLong(0L));
                this.compute(startVertex, direction, edgeLabelId, degree, depth);
            }
            if (topN > 0L || topN == -1L) {
                return HugeTraverser.topN(this.globalStresses, true, topN);
            }
            return this.globalStresses;
        }

        @Override
        protected StressNode createStartNode() {
            return new StressNode(1, 0);
        }

        @Override
        protected StressNode createNode(StressNode parentNode) {
            return new StressNode(parentNode);
        }

        @Override
        protected void meetNode(Id currentVertex, StressNode currentNode, Id parentVertex, StressNode parentNode, boolean firstTime) {
            currentNode.addParentNode(parentNode, parentVertex);
        }

        @Override
        protected void backtrack(Id startVertex, Id currentVertex, Map<Id, StressNode> localNodes) {
            if (startVertex.equals(currentVertex)) {
                return;
            }
            StressNode currentNode = localNodes.get(currentVertex);
            MutableLong stress = this.globalStresses.get(currentVertex);
            if (stress == null) {
                stress = new MutableLong(0L);
                this.globalStresses.put(currentVertex, stress);
            }
            stress.add(currentNode.stress());
            for (Id v : currentNode.parents()) {
                StressNode parentNode = localNodes.get(v);
                parentNode.increaseStress(currentNode);
            }
        }
    }
}

