/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.SemiJoinHint;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class QBJoinTree
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String leftAlias;
    private String[] rightAliases;
    private String[] leftAliases;
    private QBJoinTree joinSrc;
    private String[] baseSrc;
    private int nextTag = 0;
    private JoinCond[] joinCond;
    private boolean noOuterJoin = true;
    private boolean noSemiJoin = true;
    private Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo;
    private String id;
    private final transient HashMap<String, ArrayList<ASTNode>> rhsSemijoin = new HashMap();
    private transient ArrayList<ArrayList<ASTNode>> expressions;
    private ArrayList<Boolean> nullsafes;
    private transient ArrayList<ArrayList<ASTNode>> filters;
    private int[][] filterMap;
    private transient ArrayList<ArrayList<ASTNode>> filtersForPushing;
    private boolean mapSideJoin;
    private List<String> mapAliases;
    private List<String> streamAliases;
    private final List<ASTNode> postJoinFilters;
    private Map<String, SemiJoinHint> semiJoinHint;

    public QBJoinTree() {
        this.aliasToOpInfo = new HashMap<String, Operator<? extends OperatorDesc>>();
        this.postJoinFilters = new ArrayList<ASTNode>();
    }

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public void setLeftAlias(String leftAlias) {
        this.leftAlias = this.leftAlias != null && !this.leftAlias.equals(leftAlias) ? null : leftAlias;
    }

    public String[] getRightAliases() {
        return this.rightAliases;
    }

    public void setRightAliases(String[] rightAliases) {
        this.rightAliases = rightAliases;
    }

    public String[] getLeftAliases() {
        return this.leftAliases;
    }

    public void setLeftAliases(String[] leftAliases) {
        this.leftAliases = leftAliases;
    }

    public ArrayList<ArrayList<ASTNode>> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<ArrayList<ASTNode>> expressions) {
        this.expressions = expressions;
    }

    public String[] getBaseSrc() {
        return this.baseSrc;
    }

    public void setBaseSrc(String[] baseSrc) {
        this.baseSrc = baseSrc;
    }

    public QBJoinTree getJoinSrc() {
        return this.joinSrc;
    }

    public void setJoinSrc(QBJoinTree joinSrc) {
        this.joinSrc = joinSrc;
    }

    public int getNextTag() {
        return this.nextTag++;
    }

    public JoinCond[] getJoinCond() {
        return this.joinCond;
    }

    public void setJoinCond(JoinCond[] joinCond) {
        this.joinCond = joinCond;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    public boolean getNoSemiJoin() {
        return this.noSemiJoin;
    }

    public void setNoSemiJoin(boolean semi) {
        this.noSemiJoin = semi;
    }

    public ArrayList<ArrayList<ASTNode>> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<ArrayList<ASTNode>> filters) {
        this.filters = filters;
    }

    public ArrayList<ArrayList<ASTNode>> getFiltersForPushing() {
        return this.filtersForPushing;
    }

    public void setFiltersForPushing(ArrayList<ArrayList<ASTNode>> filters) {
        this.filtersForPushing = filters;
    }

    public boolean isMapSideJoin() {
        return this.mapSideJoin;
    }

    public void setMapSideJoin(boolean mapSideJoin) {
        this.mapSideJoin = mapSideJoin;
    }

    public List<String> getMapAliases() {
        return this.mapAliases;
    }

    public void setMapAliases(List<String> mapAliases) {
        this.mapAliases = mapAliases;
    }

    public List<String> getStreamAliases() {
        return this.streamAliases;
    }

    public void setStreamAliases(List<String> streamAliases) {
        this.streamAliases = streamAliases;
    }

    public void addRHSSemijoin(String alias) {
        if (!this.rhsSemijoin.containsKey(alias)) {
            this.rhsSemijoin.put(alias, null);
        }
    }

    public void addRHSSemijoinColumns(String alias, ArrayList<ASTNode> columns) {
        ArrayList<ASTNode> cols = this.rhsSemijoin.get(alias);
        if (cols == null) {
            this.rhsSemijoin.put(alias, columns);
        } else {
            cols.addAll(columns);
        }
    }

    public void addRHSSemijoinColumns(String alias, ASTNode column) {
        ArrayList<ASTNode> cols = this.rhsSemijoin.get(alias);
        if (cols == null) {
            cols = new ArrayList();
            cols.add(column);
            this.rhsSemijoin.put(alias, cols);
        } else {
            cols.add(column);
        }
    }

    public ArrayList<ASTNode> getRHSSemijoinColumns(String alias) {
        return this.rhsSemijoin.get(alias);
    }

    public void mergeRHSSemijoin(QBJoinTree src) {
        for (Map.Entry<String, ArrayList<ASTNode>> e : src.rhsSemijoin.entrySet()) {
            String key = e.getKey();
            ArrayList<ASTNode> value = this.rhsSemijoin.get(key);
            if (value == null) {
                this.rhsSemijoin.put(key, e.getValue());
                continue;
            }
            value.addAll((Collection<ASTNode>)e.getValue());
        }
    }

    public ArrayList<Boolean> getNullSafes() {
        return this.nullsafes;
    }

    public void setNullSafes(ArrayList<Boolean> nullSafes) {
        this.nullsafes = nullSafes;
    }

    public void addFilterMapping(int outer, int target, int length) {
        this.filterMap[outer] = new int[]{target, length};
    }

    public int[][] getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(int[][] filterMap) {
        this.filterMap = filterMap;
    }

    public Map<String, Operator<? extends OperatorDesc>> getAliasToOpInfo() {
        return this.aliasToOpInfo;
    }

    public void setAliasToOpInfo(Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo) {
        this.aliasToOpInfo = aliasToOpInfo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addPostJoinFilter(ASTNode filter) {
        this.postJoinFilters.add(filter);
    }

    public List<ASTNode> getPostJoinFilters() {
        return this.postJoinFilters;
    }

    public QBJoinTree clone() throws CloneNotSupportedException {
        JoinCond[] clonedJoinCond;
        int[][] clonedFilterMap;
        QBJoinTree cloned = new QBJoinTree();
        cloned.setAliasToOpInfo((Map<String, Operator<? extends OperatorDesc>>)(this.aliasToOpInfo == null ? null : new HashMap<String, Operator<? extends OperatorDesc>>(this.aliasToOpInfo)));
        cloned.setBaseSrc(this.baseSrc == null ? null : (String[])this.baseSrc.clone());
        cloned.setExpressions(this.expressions);
        cloned.setFilters(this.filters);
        cloned.setFiltersForPushing(this.filtersForPushing);
        Object object = clonedFilterMap = this.filterMap == null ? (int[][])null : (Object)new int[this.filterMap.length][];
        if (this.filterMap != null) {
            for (int i = 0; i < this.filterMap.length; ++i) {
                clonedFilterMap[i] = this.filterMap[i] == null ? null : (int[])this.filterMap[i].clone();
            }
        }
        cloned.setFilterMap(clonedFilterMap);
        cloned.setId(this.id);
        JoinCond[] joinCondArray = clonedJoinCond = this.joinCond == null ? null : new JoinCond[this.joinCond.length];
        if (this.joinCond != null) {
            for (int i = 0; i < this.joinCond.length; ++i) {
                if (this.joinCond[i] == null) continue;
                JoinCond joinCond = new JoinCond();
                joinCond.setJoinType(this.joinCond[i].getJoinType());
                joinCond.setLeft(this.joinCond[i].getLeft());
                joinCond.setPreserved(this.joinCond[i].getPreserved());
                joinCond.setRight(this.joinCond[i].getRight());
                clonedJoinCond[i] = joinCond;
            }
        }
        cloned.setJoinCond(clonedJoinCond);
        cloned.setJoinSrc(this.joinSrc == null ? null : this.joinSrc.clone());
        cloned.setLeftAlias(this.leftAlias);
        cloned.setLeftAliases(this.leftAliases == null ? null : (String[])this.leftAliases.clone());
        cloned.setMapAliases((List<String>)(this.mapAliases == null ? null : new ArrayList<String>(this.mapAliases)));
        cloned.setMapSideJoin(this.mapSideJoin);
        cloned.setNoOuterJoin(this.noOuterJoin);
        cloned.setNoSemiJoin(this.noSemiJoin);
        cloned.setNullSafes(this.nullsafes == null ? null : new ArrayList<Boolean>(this.nullsafes));
        cloned.setRightAliases(this.rightAliases == null ? null : (String[])this.rightAliases.clone());
        cloned.setStreamAliases((List<String>)(this.streamAliases == null ? null : new ArrayList<String>(this.streamAliases)));
        for (ASTNode aSTNode : this.postJoinFilters) {
            cloned.addPostJoinFilter(aSTNode);
        }
        for (Map.Entry entry : this.rhsSemijoin.entrySet()) {
            cloned.addRHSSemijoinColumns((String)entry.getKey(), (ArrayList)entry.getValue());
        }
        return cloned;
    }

    public void setSemiJoinHint(Map<String, SemiJoinHint> semiJoinHint) {
        this.semiJoinHint = semiJoinHint;
    }

    public Map<String, SemiJoinHint> getSemiJoinHint() {
        return this.semiJoinHint;
    }

    public String toString() {
        return "QBJoinTree [leftAlias=" + this.leftAlias + ", rightAliases=" + Arrays.toString(this.rightAliases) + ", leftAliases=" + Arrays.toString(this.leftAliases) + ", semiJoinHint=" + this.semiJoinHint + "]";
    }
}

