/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.util.function.Supplier;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcConf;
import org.apache.orc.impl.InStream;

public final class DataReaderProperties {
    private final Supplier<FileSystem> fileSystemSupplier;
    private final Path path;
    private final FSDataInputStream file;
    private final InStream.StreamOptions compression;
    private final boolean zeroCopy;
    private final int maxDiskRangeChunkLimit;

    private DataReaderProperties(Builder builder) {
        this.fileSystemSupplier = builder.fileSystemSupplier;
        this.path = builder.path;
        this.file = builder.file;
        this.compression = builder.compression;
        this.zeroCopy = builder.zeroCopy;
        this.maxDiskRangeChunkLimit = builder.maxDiskRangeChunkLimit;
    }

    public Supplier<FileSystem> getFileSystemSupplier() {
        return this.fileSystemSupplier;
    }

    public Path getPath() {
        return this.path;
    }

    public FSDataInputStream getFile() {
        return this.file;
    }

    public InStream.StreamOptions getCompression() {
        return this.compression;
    }

    public boolean getZeroCopy() {
        return this.zeroCopy;
    }

    public int getMaxDiskRangeChunkLimit() {
        return this.maxDiskRangeChunkLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<FileSystem> fileSystemSupplier;
        private Path path;
        private FSDataInputStream file;
        private InStream.StreamOptions compression;
        private boolean zeroCopy;
        private int maxDiskRangeChunkLimit = (Integer)OrcConf.ORC_MAX_DISK_RANGE_CHUNK_LIMIT.getDefaultValue();

        private Builder() {
        }

        public Builder withFileSystemSupplier(Supplier<FileSystem> supplier) {
            this.fileSystemSupplier = supplier;
            return this;
        }

        public Builder withFileSystem(FileSystem filesystem) {
            this.fileSystemSupplier = () -> filesystem;
            return this;
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withFile(FSDataInputStream file) {
            this.file = file;
            return this;
        }

        public Builder withCompression(InStream.StreamOptions value) {
            this.compression = value;
            return this;
        }

        public Builder withZeroCopy(boolean zeroCopy) {
            this.zeroCopy = zeroCopy;
            return this;
        }

        public Builder withMaxDiskRangeChunkLimit(int value) {
            this.maxDiskRangeChunkLimit = value;
            return this;
        }

        public DataReaderProperties build() {
            if (this.fileSystemSupplier == null || this.path == null) {
                throw new NullPointerException("Filesystem = " + this.fileSystemSupplier + ", path = " + this.path);
            }
            return new DataReaderProperties(this);
        }
    }
}

