/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.jetbrains.annotations.Nullable;

public class CatalogSerializationUtils {
    @Nullable
    public static String readNullableString(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static void writeNullableString(@Nullable String str, DataOutput out) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }

    public static void writeStringCollection(@Nullable Collection<String> list, CatalogObjectDataOutput out) throws IOException {
        if (list == null) {
            out.writeVarInt(-1L);
            return;
        }
        out.writeVarInt(list.size());
        for (String item : list) {
            out.writeUTF(item);
        }
    }

    @Nullable
    public static <T extends Collection<String>> T readStringCollection(CatalogObjectDataInput in, IntFunction<T> factory) throws IOException {
        int size = in.readVarIntAsInt();
        if (size == -1) {
            return null;
        }
        Collection collection = (Collection)factory.apply(size);
        for (int i = 0; i < size; ++i) {
            collection.add(in.readUTF());
        }
        return (T)collection;
    }

    public static <T> T[] readArray(CatalogObjectSerializer<T> serializer, CatalogObjectDataInput input, Class<T> clazz) throws IOException {
        int len = input.readVarIntAsInt();
        Object[] arr = (Object[])Array.newInstance(clazz, len);
        for (int i = 0; i < len; ++i) {
            arr[i] = serializer.readFrom(input);
        }
        return arr;
    }

    public static <T> void writeArray(T[] items, CatalogObjectSerializer<T> serializer, CatalogObjectDataOutput output) throws IOException {
        output.writeVarInt(items.length);
        for (T item : items) {
            serializer.writeTo(item, output);
        }
    }

    public static <T> List<T> readList(CatalogObjectSerializer<T> serializer, CatalogObjectDataInput input) throws IOException {
        int len = input.readVarIntAsInt();
        ArrayList<T> entries = new ArrayList<T>(len);
        for (int i = 0; i < len; ++i) {
            T item = serializer.readFrom(input);
            entries.add(item);
        }
        return entries;
    }

    public static <T> void writeList(List<T> items, CatalogObjectSerializer<T> serializer, CatalogObjectDataOutput output) throws IOException {
        output.writeVarInt(items.size());
        for (T item : items) {
            serializer.writeTo(item, output);
        }
    }

    @Deprecated
    public static class IndexDescriptorSerializerHelper
    implements CatalogObjectSerializer<CatalogIndexDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public IndexDescriptorSerializerHelper(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            byte idxType = input.readByte();
            CatalogIndexDescriptor.CatalogIndexDescriptorType type = CatalogIndexDescriptor.CatalogIndexDescriptorType.forId(idxType);
            if (type == CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH) {
                return (CatalogIndexDescriptor)this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_HASH_INDEX.id()).readFrom(input);
            }
            return (CatalogIndexDescriptor)this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SORTED_INDEX.id()).readFrom(input);
        }

        @Override
        public void writeTo(CatalogIndexDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeByte(descriptor.indexType().id());
            this.serializers.get(1, descriptor.typeId()).writeTo(descriptor, output);
        }
    }
}

