/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.config.ini;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.config.CliConfigKeys;
import org.apache.ignite3.internal.cli.config.Profile;
import org.apache.ignite3.internal.cli.config.ini.IniConfig;

public class IniProfile
implements Profile {
    private final String name;
    private final IniConfig config;
    private final IniConfig secretConfig;

    public IniProfile(String name, IniConfig config, IniConfig secretConfig) {
        this.name = name;
        this.config = config;
        this.secretConfig = secretConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getAll() {
        HashMap<String, String> all = new HashMap<String, String>(this.config.getAll());
        all.putAll(this.secretConfig.getAll());
        return all;
    }

    @Override
    public String getProperty(String key) {
        return this.getConfig(key).getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getConfig(key).getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        this.getConfig(key).setProperty(key, value);
    }

    @Override
    public String removeProperty(String key) {
        return this.getConfig(key).removeProperty(key);
    }

    @Override
    public void setProperties(Map<String, String> values) {
        Map<String, String> secretConfigValues;
        Map<Boolean, Map<String, String>> secretToValues = values.entrySet().stream().collect(Collectors.groupingBy(it -> CliConfigKeys.secretConfigKeys().contains(it.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Map<String, String> configValues = secretToValues.get(false);
        if (configValues != null) {
            this.config.setProperties(configValues);
        }
        if ((secretConfigValues = secretToValues.get(true)) != null) {
            this.secretConfig.setProperties(secretConfigValues);
        }
    }

    private IniConfig getConfig(String key) {
        return CliConfigKeys.secretConfigKeys().contains(key) ? this.secretConfig : this.config;
    }
}

