/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinResultSet;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;

public class JdbcThinDatabaseMetadata
implements DatabaseMetaData {
    public static final String DRIVER_NAME = "Apache Ignite Thin JDBC Driver";
    private final JdbcThinConnection conn;

    JdbcThinDatabaseMetadata(JdbcThinConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.url();
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Apache Ignite";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.igniteVersion().toString();
    }

    @Override
    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return IgniteVersionUtils.VER.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return IgniteVersionUtils.VER.major();
    }

    @Override
    public int getDriverMinorVersion() {
        return IgniteVersionUtils.VER.minor();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "LIMIT,MINUS,ROWNUM,SYSDATE,SYSTIME,SYSTIMESTAMP,TODAY";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.conn.defaultTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.conn.isTxAwareQueriesSupported;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.conn.isTxAwareQueriesSupported && this.conn.isolationLevelSupported(level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.conn.isTxAwareQueriesSupported;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPtrn, String procedureNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "PROCEDURE_CAT", String.class), new JdbcColumnMeta(null, null, "PROCEDURE_SCHEM", String.class), new JdbcColumnMeta(null, null, "PROCEDURE_NAME", String.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "PROCEDURE_TYPE", String.class), new JdbcColumnMeta(null, null, "SPECIFIC_NAME", String.class)));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPtrn, String procedureNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "PROCEDURE_CAT", String.class), new JdbcColumnMeta(null, null, "PROCEDURE_SCHEM", String.class), new JdbcColumnMeta(null, null, "PROCEDURE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_TYPE", Short.class), new JdbcColumnMeta(null, null, "COLUMN_TYPE", Integer.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "PRECISION", Integer.class), new JdbcColumnMeta(null, null, "LENGTH", Integer.class), new JdbcColumnMeta(null, null, "SCALE", Short.class), new JdbcColumnMeta(null, null, "RADIX", Short.class), new JdbcColumnMeta(null, null, "NULLABLE", Short.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "COLUMN_DEF", String.class), new JdbcColumnMeta(null, null, "SQL_DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "SQL_DATETIME_SUB", Integer.class), new JdbcColumnMeta(null, null, "CHAR_OCTET_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "ORDINAL_POSITION", Integer.class), new JdbcColumnMeta(null, null, "IS_NULLABLE", String.class), new JdbcColumnMeta(null, null, "SPECIFIC_NAME", String.class)));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPtrn, String tblNamePtrn, String[] tblTypes) throws SQLException {
        this.conn.ensureNotClosed();
        List<JdbcColumnMeta> meta = Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "TABLE_TYPE", String.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "TYPE_CAT", String.class), new JdbcColumnMeta(null, null, "TYPE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "SELF_REFERENCING_COL_NAME", String.class), new JdbcColumnMeta(null, null, "REF_GENERATION", String.class));
        boolean tblTypeMatch = false;
        if (tblTypes == null) {
            tblTypeMatch = true;
        } else {
            for (String type : tblTypes) {
                if (!"TABLE".equals(type) && !"VIEW".equals(type)) continue;
                tblTypeMatch = true;
                break;
            }
        }
        if (!JdbcThinDatabaseMetadata.isValidCatalog(catalog) || !tblTypeMatch) {
            return new JdbcThinResultSet(Collections.emptyList(), meta);
        }
        JdbcMetaTablesResult res = (JdbcMetaTablesResult)this.conn.sendRequest(new JdbcMetaTablesRequest(schemaPtrn, tblNamePtrn, tblTypes)).response();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (JdbcTableMeta tblMeta : res.meta()) {
            rows.add(JdbcUtils.tableRow(tblMeta));
        }
        return new JdbcThinResultSet(rows, meta);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new JdbcThinResultSet(Collections.singletonList(Collections.singletonList("IGNITE")), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class)));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new JdbcThinResultSet(Arrays.asList(Collections.singletonList("TABLE"), Collections.singletonList("VIEW")), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_TYPE", String.class)));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        this.conn.ensureNotClosed();
        List<JdbcColumnMeta> meta = Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Short.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_SIZE", Integer.class), new JdbcColumnMeta(null, null, "BUFFER_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "DECIMAL_DIGITS", Integer.class), new JdbcColumnMeta(null, null, "NUM_PREC_RADIX", Short.class), new JdbcColumnMeta(null, null, "NULLABLE", Short.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "COLUMN_DEF", String.class), new JdbcColumnMeta(null, null, "SQL_DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "SQL_DATETIME_SUB", Integer.class), new JdbcColumnMeta(null, null, "CHAR_OCTET_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "ORDINAL_POSITION", Integer.class), new JdbcColumnMeta(null, null, "IS_NULLABLE", String.class), new JdbcColumnMeta(null, null, "SCOPE_CATLOG", String.class), new JdbcColumnMeta(null, null, "SCOPE_SCHEMA", String.class), new JdbcColumnMeta(null, null, "SCOPE_TABLE", String.class), new JdbcColumnMeta(null, null, "SOURCE_DATA_TYPE", Short.class), new JdbcColumnMeta(null, null, "IS_AUTOINCREMENT", String.class), new JdbcColumnMeta(null, null, "IS_GENERATEDCOLUMN", String.class));
        if (!JdbcThinDatabaseMetadata.isValidCatalog(catalog)) {
            return new JdbcThinResultSet(Collections.emptyList(), meta);
        }
        JdbcMetaColumnsResult res = (JdbcMetaColumnsResult)this.conn.sendRequest(new JdbcMetaColumnsRequest(schemaPtrn, tblNamePtrn, colNamePtrn)).response();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (int i = 0; i < res.meta().size(); ++i) {
            rows.add(JdbcUtils.columnRow(res.meta().get(i), i + 1));
        }
        return new JdbcThinResultSet(rows, meta);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String tbl, String colNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "GRANTOR", String.class), new JdbcColumnMeta(null, null, "GRANTEE", String.class), new JdbcColumnMeta(null, null, "PRIVILEGE", String.class), new JdbcColumnMeta(null, null, "IS_GRANTABLE", String.class)));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "GRANTOR", String.class), new JdbcColumnMeta(null, null, "GRANTEE", String.class), new JdbcColumnMeta(null, null, "PRIVILEGE", String.class), new JdbcColumnMeta(null, null, "IS_GRANTABLE", String.class)));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String tbl, int scope, boolean nullable) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "SCOPE", Short.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_SIZE", Integer.class), new JdbcColumnMeta(null, null, "BUFFER_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "DECIMAL_DIGITS", Short.class), new JdbcColumnMeta(null, null, "PSEUDO_COLUMN", Short.class)));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "SCOPE", Short.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_SIZE", Integer.class), new JdbcColumnMeta(null, null, "BUFFER_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "DECIMAL_DIGITS", Short.class), new JdbcColumnMeta(null, null, "PSEUDO_COLUMN", Short.class)));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String tbl) throws SQLException {
        this.conn.ensureNotClosed();
        List<JdbcColumnMeta> meta = Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "KEY_SEQ", Short.class), new JdbcColumnMeta(null, null, "PK_NAME", String.class));
        if (!JdbcThinDatabaseMetadata.isValidCatalog(catalog)) {
            return new JdbcThinResultSet(Collections.emptyList(), meta);
        }
        JdbcMetaPrimaryKeysResult res = (JdbcMetaPrimaryKeysResult)this.conn.sendRequest(new JdbcMetaPrimaryKeysRequest(schema, tbl)).response();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (JdbcPrimaryKeyMeta pkMeta : res.meta()) {
            rows.addAll(JdbcUtils.primaryKeyRows(pkMeta));
        }
        return new JdbcThinResultSet(rows, meta);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "PKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "PKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "PKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "PKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "FKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "FKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "FKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "FKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "KEY_SEQ", Short.class), new JdbcColumnMeta(null, null, "UPDATE_RULE", Short.class), new JdbcColumnMeta(null, null, "DELETE_RULE", Short.class), new JdbcColumnMeta(null, null, "FK_NAME", String.class), new JdbcColumnMeta(null, null, "PK_NAME", String.class), new JdbcColumnMeta(null, null, "DEFERRABILITY", Short.class)));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "PKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "PKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "PKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "PKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "FKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "FKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "FKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "FKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "KEY_SEQ", Short.class), new JdbcColumnMeta(null, null, "UPDATE_RULE", Short.class), new JdbcColumnMeta(null, null, "DELETE_RULE", Short.class), new JdbcColumnMeta(null, null, "FK_NAME", String.class), new JdbcColumnMeta(null, null, "PK_NAME", String.class), new JdbcColumnMeta(null, null, "DEFERRABILITY", Short.class)));
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTbl, String foreignCatalog, String foreignSchema, String foreignTbl) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "PKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "PKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "PKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "PKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "FKTABLE_CAT", String.class), new JdbcColumnMeta(null, null, "FKTABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "FKTABLE_NAME", String.class), new JdbcColumnMeta(null, null, "FKCOLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "KEY_SEQ", Short.class), new JdbcColumnMeta(null, null, "UPDATE_RULE", Short.class), new JdbcColumnMeta(null, null, "DELETE_RULE", Short.class), new JdbcColumnMeta(null, null, "FK_NAME", String.class), new JdbcColumnMeta(null, null, "PK_NAME", String.class), new JdbcColumnMeta(null, null, "DEFERRABILITY", Short.class)));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ArrayList<List<Object>> types = new ArrayList<List<Object>>(21);
        types.add(Arrays.asList("BOOLEAN", 16, 1, null, null, null, (short)1, false, (short)3, false, false, false, "BOOLEAN", 0, 0, 16, 0, 10));
        types.add(Arrays.asList("TINYINT", -6, 3, null, null, null, (short)1, false, (short)3, false, false, false, "TINYINT", 0, 0, -6, 0, 10));
        types.add(Arrays.asList("SMALLINT", 5, 5, null, null, null, (short)1, false, (short)3, false, false, false, "SMALLINT", 0, 0, 5, 0, 10));
        types.add(Arrays.asList("INTEGER", 4, 10, null, null, null, (short)1, false, (short)3, false, false, false, "INTEGER", 0, 0, 4, 0, 10));
        types.add(Arrays.asList("BIGINT", -5, 19, null, null, null, (short)1, false, (short)3, false, false, false, "BIGINT", 0, 0, -5, 0, 10));
        types.add(Arrays.asList("FLOAT", 6, 17, null, null, null, (short)1, false, (short)3, false, false, false, "FLOAT", 0, 0, 6, 0, 10));
        types.add(Arrays.asList("REAL", 7, 7, null, null, null, (short)1, false, (short)3, false, false, false, "REAL", 0, 0, 7, 0, 10));
        types.add(Arrays.asList("DOUBLE", 8, 17, null, null, null, (short)1, false, (short)3, false, false, false, "DOUBLE", 0, 0, 8, 0, 10));
        types.add(Arrays.asList("NUMERIC", 2, Integer.MAX_VALUE, null, null, "PRECISION,SCALE", (short)1, false, (short)3, false, false, false, "NUMERIC", 0, 0, 2, 0, 10));
        types.add(Arrays.asList("DECIMAL", 3, Integer.MAX_VALUE, null, null, "PRECISION,SCALE", (short)1, false, (short)3, false, false, false, "DECIMAL", 0, 0, 3, 0, 10));
        types.add(Arrays.asList("DATE", 91, 8, "DATE '", "'", null, (short)1, false, (short)3, false, false, false, "DATE", 0, 0, 91, 0, null));
        types.add(Arrays.asList("TIME", 92, 6, "TIME '", "'", null, (short)1, false, (short)3, false, false, false, "TIME", 0, 0, 92, 0, null));
        types.add(Arrays.asList("TIMESTAMP", 93, 23, "TIMESTAMP '", "'", null, (short)1, false, (short)3, false, false, false, "TIMESTAMP", 0, 10, 93, 0, null));
        types.add(Arrays.asList("CHAR", 1, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "CHAR", 0, 0, 1, 0, null));
        types.add(Arrays.asList("VARCHAR", 12, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "VARCHAR", 0, 0, 12, 0, null));
        types.add(Arrays.asList("LONGVARCHAR", -1, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "LONGVARCHAR", 0, 0, -1, 0, null));
        types.add(Arrays.asList("BINARY", -2, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "BINARY", 0, 0, -2, 0, null));
        types.add(Arrays.asList("VARBINARY", -3, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "VARBINARY", 0, 0, -3, 0, null));
        types.add(Arrays.asList("LONGVARBINARY", -4, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "LONGVARBINARY", 0, 0, -4, 0, null));
        types.add(Arrays.asList("OTHER", 1111, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "OTHER", 0, 0, 1111, 0, null));
        types.add(Arrays.asList("ARRAY", 2003, 0, "(", "')", null, (short)1, false, (short)3, false, false, false, "ARRAY", 0, 0, 2003, 0, null));
        return new JdbcThinResultSet(types, Arrays.asList(new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "PRECISION", Integer.class), new JdbcColumnMeta(null, null, "LITERAL_PREFIX", String.class), new JdbcColumnMeta(null, null, "LITERAL_SUFFIX", String.class), new JdbcColumnMeta(null, null, "CREATE_PARAMS", String.class), new JdbcColumnMeta(null, null, "NULLABLE", Short.class), new JdbcColumnMeta(null, null, "CASE_SENSITIVE", Boolean.class), new JdbcColumnMeta(null, null, "SEARCHABLE", Short.class), new JdbcColumnMeta(null, null, "UNSIGNED_ATTRIBUTE", Boolean.class), new JdbcColumnMeta(null, null, "FIXED_PREC_SCALE", Boolean.class), new JdbcColumnMeta(null, null, "AUTO_INCREMENT", Boolean.class), new JdbcColumnMeta(null, null, "LOCAL_TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "MINIMUM_SCALE", Short.class), new JdbcColumnMeta(null, null, "MAXIMUM_SCALE", Short.class), new JdbcColumnMeta(null, null, "SQL_DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "SQL_DATETIME_SUB", Integer.class), new JdbcColumnMeta(null, null, "NUM_PREC_RADIX", Integer.class)));
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tbl, boolean unique, boolean approximate) throws SQLException {
        this.conn.ensureNotClosed();
        List<JdbcColumnMeta> meta = Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "NON_UNIQUE", Boolean.class), new JdbcColumnMeta(null, null, "INDEX_QUALIFIER", String.class), new JdbcColumnMeta(null, null, "INDEX_NAME", String.class), new JdbcColumnMeta(null, null, "TYPE", Short.class), new JdbcColumnMeta(null, null, "ORDINAL_POSITION", Short.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "ASC_OR_DESC", String.class), new JdbcColumnMeta(null, null, "CARDINALITY", Integer.class), new JdbcColumnMeta(null, null, "PAGES", Integer.class), new JdbcColumnMeta(null, null, "FILTER_CONDITION", String.class));
        if (!JdbcThinDatabaseMetadata.isValidCatalog(catalog)) {
            return new JdbcThinResultSet(Collections.emptyList(), meta);
        }
        JdbcMetaIndexesResult res = (JdbcMetaIndexesResult)this.conn.sendRequest(new JdbcMetaIndexesRequest(schema, tbl)).response();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (JdbcIndexMeta idxMeta : res.meta()) {
            rows.addAll(JdbcUtils.indexRows(idxMeta));
        }
        return new JdbcThinResultSet(rows, meta);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.supportsResultSetType(type) && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPtrn, String typeNamePtrn, int[] types) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TYPE_CAT", String.class), new JdbcColumnMeta(null, null, "TYPE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "CLASS_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "BASE_TYPE", Short.class)));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPtrn, String typeNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TYPE_CAT", String.class), new JdbcColumnMeta(null, null, "TYPE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "SUPERTYPE_CAT", String.class), new JdbcColumnMeta(null, null, "SUPERTYPE_SCHEM", String.class), new JdbcColumnMeta(null, null, "SUPERTYPE_NAME", String.class)));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "SUPERTABLE_NAME", String.class)));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPtrn, String typeNamePtrn, String attributeNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TYPE_CAT", String.class), new JdbcColumnMeta(null, null, "TYPE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "ATTR_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "ATTR_TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "ATTR_SIZE", Integer.class), new JdbcColumnMeta(null, null, "DECIMAL_DIGITS", Integer.class), new JdbcColumnMeta(null, null, "NUM_PREC_RADIX", Integer.class), new JdbcColumnMeta(null, null, "NULLABLE", Integer.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "ATTR_DEF", String.class), new JdbcColumnMeta(null, null, "SQL_DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "SQL_DATETIME_SUB", Integer.class), new JdbcColumnMeta(null, null, "CHAR_OCTET_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "ORDINAL_POSITION", Integer.class), new JdbcColumnMeta(null, null, "IS_NULLABLE", String.class), new JdbcColumnMeta(null, null, "SCOPE_CATALOG", String.class), new JdbcColumnMeta(null, null, "SCOPE_SCHEMA", String.class), new JdbcColumnMeta(null, null, "SCOPE_TABLE", String.class), new JdbcColumnMeta(null, null, "SOURCE_DATA_TYPE", Short.class)));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.igniteVersion().major();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.igniteVersion().minor();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPtrn) throws SQLException {
        this.conn.ensureNotClosed();
        List<JdbcColumnMeta> meta = Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_CATALOG", String.class));
        if (!JdbcThinDatabaseMetadata.isValidCatalog(catalog)) {
            return new JdbcThinResultSet(Collections.emptyList(), meta);
        }
        JdbcMetaSchemasResult res = (JdbcMetaSchemasResult)this.conn.sendRequest(new JdbcMetaSchemasRequest(schemaPtrn)).response();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (String schema : res.schemas()) {
            ArrayList<String> row = new ArrayList<String>(2);
            row.add(schema);
            row.add("IGNITE");
            rows.add(row);
        }
        return new JdbcThinResultSet(rows, meta);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "NAME", String.class), new JdbcColumnMeta(null, null, "MAX_LEN", Integer.class), new JdbcColumnMeta(null, null, "DEFAULT_VALUE", String.class), new JdbcColumnMeta(null, null, "DESCRIPTION", String.class)));
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPtrn, String functionNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "FUNCTION_CAT", String.class), new JdbcColumnMeta(null, null, "FUNCTION_SCHEM", String.class), new JdbcColumnMeta(null, null, "FUNCTION_NAME", String.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "FUNCTION_TYPE", String.class), new JdbcColumnMeta(null, null, "SPECIFIC_NAME", String.class)));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPtrn, String functionNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "FUNCTION_CAT", String.class), new JdbcColumnMeta(null, null, "FUNCTION_SCHEM", String.class), new JdbcColumnMeta(null, null, "FUNCTION_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_TYPE", Short.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "TYPE_NAME", String.class), new JdbcColumnMeta(null, null, "PRECISION", Integer.class), new JdbcColumnMeta(null, null, "LENGTH", Integer.class), new JdbcColumnMeta(null, null, "SCALE", Short.class), new JdbcColumnMeta(null, null, "RADIX", Short.class), new JdbcColumnMeta(null, null, "NULLABLE", Short.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "CHAR_OCTET_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "ORDINAL_POSITION", Integer.class), new JdbcColumnMeta(null, null, "IS_NULLABLE", String.class), new JdbcColumnMeta(null, null, "SPECIFIC_NAME", String.class)));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Database meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinDatabaseMetadata.class);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcThinResultSet(Collections.emptyList(), Arrays.asList(new JdbcColumnMeta(null, null, "TABLE_CAT", String.class), new JdbcColumnMeta(null, null, "TABLE_SCHEM", String.class), new JdbcColumnMeta(null, null, "TABLE_NAME", String.class), new JdbcColumnMeta(null, null, "COLUMN_NAME", String.class), new JdbcColumnMeta(null, null, "DATA_TYPE", Integer.class), new JdbcColumnMeta(null, null, "COLUMN_SIZE", Integer.class), new JdbcColumnMeta(null, null, "DECIMAL_DIGITS", Integer.class), new JdbcColumnMeta(null, null, "NUM_PREC_RADIX", Integer.class), new JdbcColumnMeta(null, null, "COLUMN_USAGE", Integer.class), new JdbcColumnMeta(null, null, "REMARKS", String.class), new JdbcColumnMeta(null, null, "CHAR_OCTET_LENGTH", Integer.class), new JdbcColumnMeta(null, null, "IS_NULLABLE", String.class)));
    }

    private static boolean isValidCatalog(String catalog) {
        return catalog == null || catalog.equalsIgnoreCase("IGNITE");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

