/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.config;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TagConfiguration {
    private boolean autoCreateTag = false;
    private String tagFormat;
    private Period triggerPeriod;
    private int triggerOffsetMinutes;
    private int maxDelayMinutes;
    private long tagMaxAgeMs;

    public boolean isAutoCreateTag() {
        return this.autoCreateTag;
    }

    public void setAutoCreateTag(boolean autoCreateTag) {
        this.autoCreateTag = autoCreateTag;
    }

    public String getTagFormat() {
        return this.tagFormat;
    }

    public void setTagFormat(String tagFormat) {
        this.tagFormat = tagFormat;
    }

    public Period getTriggerPeriod() {
        return this.triggerPeriod;
    }

    public void setTriggerPeriod(Period triggerPeriod) {
        this.triggerPeriod = triggerPeriod;
    }

    public int getTriggerOffsetMinutes() {
        return this.triggerOffsetMinutes;
    }

    public void setTriggerOffsetMinutes(int triggerOffsetMinutes) {
        this.triggerOffsetMinutes = triggerOffsetMinutes;
    }

    public int getMaxDelayMinutes() {
        return this.maxDelayMinutes;
    }

    public void setMaxDelayMinutes(int maxDelayMinutes) {
        this.maxDelayMinutes = maxDelayMinutes;
    }

    public long getTagMaxAgeMs() {
        return this.tagMaxAgeMs;
    }

    public void setTagMaxAgeMs(long tagMaxAgeMs) {
        this.tagMaxAgeMs = tagMaxAgeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagConfiguration that = (TagConfiguration)o;
        return this.autoCreateTag == that.autoCreateTag && this.triggerOffsetMinutes == that.triggerOffsetMinutes && this.maxDelayMinutes == that.maxDelayMinutes && Objects.equal((Object)this.tagFormat, (Object)that.tagFormat) && this.triggerPeriod == that.triggerPeriod && this.tagMaxAgeMs == that.tagMaxAgeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.autoCreateTag, this.tagFormat, this.triggerPeriod, this.triggerOffsetMinutes, this.maxDelayMinutes, this.tagMaxAgeMs});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("autoCreateTag", this.autoCreateTag).add("tagFormat", (Object)this.tagFormat).add("triggerPeriod", (Object)this.triggerPeriod).add("triggerOffsetMinutes", this.triggerOffsetMinutes).add("maxDelayMinutes", this.maxDelayMinutes).add("tagMaxAgeMs", this.tagMaxAgeMs).toString();
    }

    public static enum Period {
        DAILY("daily"){

            @Override
            protected Duration periodDuration() {
                return Duration.ofDays(1L);
            }

            @Override
            public LocalDateTime getTagTime(LocalDateTime checkTime, int triggerOffsetMinutes) {
                return checkTime.minusMinutes(triggerOffsetMinutes).truncatedTo(ChronoUnit.DAYS);
            }
        }
        ,
        HOURLY("hourly"){

            @Override
            protected Duration periodDuration() {
                return Duration.ofHours(1L);
            }

            @Override
            public LocalDateTime getTagTime(LocalDateTime checkTime, int triggerOffsetMinutes) {
                return checkTime.minusMinutes(triggerOffsetMinutes).truncatedTo(ChronoUnit.HOURS);
            }
        };

        private final String propertyName;

        private Period(String propertyName) {
            this.propertyName = propertyName;
        }

        public String propertyName() {
            return this.propertyName;
        }

        protected abstract Duration periodDuration();

        public abstract LocalDateTime getTagTime(LocalDateTime var1, int var2);

        public String generateTagName(LocalDateTime tagTime, String tagFormat) {
            return tagTime.minus(this.periodDuration()).format(DateTimeFormatter.ofPattern(tagFormat));
        }
    }
}

