/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;

public class GenericDeleteFilter
extends DeleteFilter<Record> {
    private final FileIO io;
    private final InternalRecordWrapper asStructLike;

    public GenericDeleteFilter(FileIO io, FileScanTask task, Schema tableSchema, Schema requestedSchema) {
        super(((DataFile)task.file()).path().toString(), task.deletes(), tableSchema, requestedSchema);
        this.io = io;
        this.asStructLike = new InternalRecordWrapper(this.requiredSchema().asStruct());
    }

    @Override
    protected long pos(Record record) {
        return (Long)this.posAccessor().get((Object)record);
    }

    @Override
    protected StructLike asStructLike(Record record) {
        return this.asStructLike.wrap((StructLike)record);
    }

    @Override
    protected InputFile getInputFile(String location) {
        return this.io.newInputFile(location);
    }
}

