/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaWithTypeVisitor;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.DecoderResolver;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.data.SparkValueReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;

public class SparkAvroReader
implements DatumReader<InternalRow>,
SupportsRowPosition {
    private final org.apache.avro.Schema readSchema;
    private final ValueReader<InternalRow> reader;
    private org.apache.avro.Schema fileSchema = null;

    public SparkAvroReader(Schema expectedSchema, org.apache.avro.Schema readSchema) {
        this(expectedSchema, readSchema, (Map<Integer, ?>)ImmutableMap.of());
    }

    public SparkAvroReader(Schema expectedSchema, org.apache.avro.Schema readSchema, Map<Integer, ?> constants) {
        this.readSchema = readSchema;
        this.reader = (ValueReader)AvroSchemaWithTypeVisitor.visit((Schema)expectedSchema, (org.apache.avro.Schema)readSchema, (AvroSchemaWithTypeVisitor)new ReadBuilder(constants));
    }

    public void setSchema(org.apache.avro.Schema newFileSchema) {
        this.fileSchema = org.apache.avro.Schema.applyAliases((org.apache.avro.Schema)newFileSchema, (org.apache.avro.Schema)this.readSchema);
    }

    public InternalRow read(InternalRow reuse, Decoder decoder) throws IOException {
        return (InternalRow)DecoderResolver.resolveAndRead((Decoder)decoder, (org.apache.avro.Schema)this.readSchema, (org.apache.avro.Schema)this.fileSchema, this.reader, (Object)reuse);
    }

    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)this.reader).setRowPositionSupplier(posSupplier);
        }
    }

    private static class ReadBuilder
    extends AvroSchemaWithTypeVisitor<ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public ValueReader<?> record(Types.StructType expected, org.apache.avro.Schema record, List<String> names, List<ValueReader<?>> fields) {
            return SparkValueReaders.struct(fields, expected, this.idToConstant);
        }

        public ValueReader<?> union(Type expected, org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        public ValueReader<?> array(Types.ListType expected, org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return SparkValueReaders.array(elementReader);
        }

        public ValueReader<?> map(Types.MapType expected, org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return SparkValueReaders.arrayMap(keyReader, valueReader);
        }

        public ValueReader<?> map(Types.MapType expected, org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return SparkValueReaders.map(SparkValueReaders.strings(), valueReader);
        }

        public ValueReader<?> primitive(Type.PrimitiveType expected, org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "timestamp-millis": {
                        ValueReader longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        return SparkValueReaders.decimal((ValueReader<byte[]>)ValueReaders.decimalBytesReader((org.apache.avro.Schema)primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return SparkValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return SparkValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.bytes();
                }
                case ENUM: {
                    return SparkValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

