/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.primitives.Ints;
import org.apache.iceberg.spark.source.BaseRowReader;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PositionDeletesRowReader
extends BaseRowReader<PositionDeletesScanTask>
implements PartitionReader<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(PositionDeletesRowReader.class);

    PositionDeletesRowReader(SparkInputPartition partition) {
        this(partition.table(), (ScanTaskGroup<PositionDeletesScanTask>)partition.taskGroup(), SnapshotUtil.schemaFor((Table)partition.table(), (String)partition.branch()), partition.expectedSchema(), partition.isCaseSensitive());
    }

    PositionDeletesRowReader(Table table, ScanTaskGroup<PositionDeletesScanTask> taskGroup, Schema tableSchema, Schema expectedSchema, boolean caseSensitive) {
        super(table, taskGroup, tableSchema, expectedSchema, caseSensitive);
        int numSplits = taskGroup.tasks().size();
        LOG.debug("Reading {} position delete file split(s) for table {}", (Object)numSplits, (Object)table.name());
    }

    @Override
    protected Stream<ContentFile<?>> referencedFiles(PositionDeletesScanTask task) {
        return Stream.of(task.file());
    }

    @Override
    protected CloseableIterator<InternalRow> open(PositionDeletesScanTask task) {
        String filePath = ((DeleteFile)task.file()).path().toString();
        LOG.debug("Opening position delete file {}", (Object)filePath);
        InputFileBlockHolder.set((String)filePath, (long)task.start(), (long)task.length());
        InputFile inputFile = this.getInputFile(((DeleteFile)task.file()).path().toString());
        Preconditions.checkNotNull((Object)inputFile, (String)"Could not find InputFile associated with %s", (Object)task);
        Map<Integer, ?> idToConstant = this.constantsMap((ContentScanTask<?>)task, this.expectedSchema());
        Set<Integer> nonConstantFieldIds = this.nonConstantFieldIds(idToConstant);
        Expression residualWithoutConstants = ExpressionUtil.extractByIdInclusive((Expression)task.residual(), (Schema)this.expectedSchema(), (boolean)this.caseSensitive(), (int[])Ints.toArray(nonConstantFieldIds));
        return this.newIterable(inputFile, ((DeleteFile)task.file()).format(), task.start(), task.length(), residualWithoutConstants, this.expectedSchema(), idToConstant).iterator();
    }

    private Set<Integer> nonConstantFieldIds(Map<Integer, ?> idToConstant) {
        Set fields = this.expectedSchema().idToName().keySet();
        return fields.stream().filter(id -> this.expectedSchema().findField(id.intValue()).type().isPrimitiveType()).filter(id -> !idToConstant.containsKey(id)).collect(Collectors.toSet());
    }
}

