/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMHeartbeatRequestHandler
extends Thread {
    public static final Logger LOG = LoggerFactory.getLogger(AMHeartbeatRequestHandler.class);
    private volatile boolean keepRunning;
    private volatile boolean isThreadWaiting;
    private Configuration conf;
    private ApplicationId applicationId;
    private BlockingQueue<AsyncAllocateRequestInfo> requestQueue;
    private AMRMClientRelayer rmProxyRelayer;
    private UserGroupInformation userUgi;
    private int lastResponseId;

    public AMHeartbeatRequestHandler(Configuration conf, ApplicationId applicationId, AMRMClientRelayer rmProxyRelayer) {
        super("AMHeartbeatRequestHandler Heartbeat Handler Thread");
        this.setUncaughtExceptionHandler(new HeartBeatThreadUncaughtExceptionHandler());
        this.keepRunning = true;
        this.isThreadWaiting = false;
        this.conf = conf;
        this.applicationId = applicationId;
        this.requestQueue = new LinkedBlockingQueue<AsyncAllocateRequestInfo>();
        this.rmProxyRelayer = rmProxyRelayer;
        this.resetLastResponseId();
    }

    public void shutdown() {
        this.keepRunning = false;
        this.interrupt();
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                this.isThreadWaiting = true;
                AsyncAllocateRequestInfo requestInfo = this.requestQueue.take();
                this.isThreadWaiting = false;
                if (requestInfo == null) {
                    throw new YarnException("Null requestInfo taken from request queue");
                }
                if (!this.keepRunning) break;
                AllocateRequest request = requestInfo.getRequest();
                if (request == null) {
                    throw new YarnException("Null allocateRequest from requestInfo");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending Heartbeat to RM. AskList:" + (request.getAskList() == null ? " empty" : Integer.valueOf(request.getAskList().size())));
                }
                request.setResponseId(this.lastResponseId);
                AllocateResponse response = this.rmProxyRelayer.allocate(request);
                if (response == null) {
                    throw new YarnException("Null allocateResponse from allocate");
                }
                this.lastResponseId = response.getResponseId();
                if (response.getAMRMToken() != null) {
                    LOG.debug("Received new AMRMToken");
                    YarnServerSecurityUtils.updateAMRMToken(response.getAMRMToken(), this.userUgi, this.conf);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received Heartbeat reply from RM. Allocated Containers:" + (response.getAllocatedContainers() == null ? " empty" : Integer.valueOf(response.getAllocatedContainers().size())));
                }
                if (requestInfo.getCallback() == null) {
                    throw new YarnException("Null callback from requestInfo");
                }
                requestInfo.getCallback().callback((Object)response);
            }
            catch (InterruptedException ex) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Interrupted while waiting for queue", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOG.warn("Error occurred while processing heart beat for " + this.applicationId, ex);
            }
        }
        LOG.info("AMHeartbeatRequestHandler thread for {} is exiting", (Object)this.applicationId);
    }

    public void resetLastResponseId() {
        this.lastResponseId = 0;
    }

    public void setUGI(UserGroupInformation ugi) {
        this.userUgi = ugi;
    }

    public void allocateAsync(AllocateRequest request, AsyncCallback<AllocateResponse> callback) throws YarnException {
        try {
            this.requestQueue.put(new AsyncAllocateRequestInfo(request, callback));
        }
        catch (InterruptedException ex) {
            LOG.debug("Interrupted while waiting to put on response queue", (Throwable)ex);
        }
    }

    @VisibleForTesting
    public void drainHeartbeatThread() {
        while (!this.isThreadWaiting || this.requestQueue.size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @VisibleForTesting
    public int getRequestQueueSize() {
        return this.requestQueue.size();
    }

    public class HeartBeatThreadUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("Heartbeat thread {} for application {} crashed!", new Object[]{t.getName(), AMHeartbeatRequestHandler.this.applicationId, e});
        }
    }

    public static class AsyncAllocateRequestInfo {
        private AllocateRequest request;
        private AsyncCallback<AllocateResponse> callback;

        public AsyncAllocateRequestInfo(AllocateRequest request, AsyncCallback<AllocateResponse> callback) {
            Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"AllocateRequest cannot be null");
            Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (Object)"Callback cannot be null");
            this.request = request;
            this.callback = callback;
        }

        public AsyncCallback<AllocateResponse> getCallback() {
            return this.callback;
        }

        public AllocateRequest getRequest() {
            return this.request;
        }
    }
}

