/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.retryable;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.flink.streaming.api.functions.async.AsyncRetryPredicate;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.util.Preconditions;

public class AsyncRetryStrategies {
    public static final NoRetryStrategy NO_RETRY_STRATEGY = new NoRetryStrategy();

    public static class ExponentialBackoffDelayRetryStrategyBuilder<OUT> {
        private final int maxAttempts;
        private final long initialDelay;
        private final long maxRetryDelay;
        private final double multiplier;
        private Predicate<Collection<OUT>> resultPredicate;
        private Predicate<Throwable> exceptionPredicate;

        public ExponentialBackoffDelayRetryStrategyBuilder(int maxAttempts, long initialDelay, long maxRetryDelay, double multiplier) {
            this.maxAttempts = maxAttempts;
            this.initialDelay = initialDelay;
            this.maxRetryDelay = maxRetryDelay;
            this.multiplier = multiplier;
        }

        public ExponentialBackoffDelayRetryStrategyBuilder<OUT> ifResult(@Nonnull Predicate<Collection<OUT>> resultRetryPredicate) {
            this.resultPredicate = resultRetryPredicate;
            return this;
        }

        public ExponentialBackoffDelayRetryStrategyBuilder<OUT> ifException(@Nonnull Predicate<Throwable> exceptionRetryPredicate) {
            this.exceptionPredicate = exceptionRetryPredicate;
            return this;
        }

        public ExponentialBackoffDelayRetryStrategy<OUT> build() {
            return new ExponentialBackoffDelayRetryStrategy<OUT>(this.maxAttempts, this.initialDelay, this.maxRetryDelay, this.multiplier, this.resultPredicate, this.exceptionPredicate);
        }
    }

    public static class ExponentialBackoffDelayRetryStrategy<OUT>
    implements AsyncRetryStrategy<OUT> {
        private static final long serialVersionUID = 1L;
        private final int maxAttempts;
        private final long maxRetryDelay;
        private final long initialDelay;
        private final double multiplier;
        private final Predicate<Collection<OUT>> resultPredicate;
        private final Predicate<Throwable> exceptionPredicate;
        private long lastRetryDelay;

        public ExponentialBackoffDelayRetryStrategy(int maxAttempts, long initialDelay, long maxRetryDelay, double multiplier, Predicate<Collection<OUT>> resultPredicate, Predicate<Throwable> exceptionPredicate) {
            this.maxAttempts = maxAttempts;
            this.maxRetryDelay = maxRetryDelay;
            this.multiplier = multiplier;
            this.resultPredicate = resultPredicate;
            this.exceptionPredicate = exceptionPredicate;
            this.initialDelay = initialDelay;
            this.lastRetryDelay = initialDelay;
        }

        @Override
        public boolean canRetry(int currentAttempts) {
            return currentAttempts <= this.maxAttempts;
        }

        @Override
        public long getBackoffTimeMillis(int currentAttempts) {
            long backoff;
            if (currentAttempts <= 1) {
                this.lastRetryDelay = this.initialDelay;
                return this.lastRetryDelay;
            }
            this.lastRetryDelay = backoff = Math.min((long)((double)this.lastRetryDelay * this.multiplier), this.maxRetryDelay);
            return backoff;
        }

        @Override
        public AsyncRetryPredicate<OUT> getRetryPredicate() {
            return new RetryPredicate<OUT>(this.resultPredicate, this.exceptionPredicate);
        }
    }

    public static class FixedDelayRetryStrategyBuilder<OUT> {
        private int maxAttempts;
        private long backoffTimeMillis;
        private Predicate<Collection<OUT>> resultPredicate;
        private Predicate<Throwable> exceptionPredicate;

        public FixedDelayRetryStrategyBuilder(int maxAttempts, long backoffTimeMillis) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than zero.");
            Preconditions.checkArgument((backoffTimeMillis > 0L ? 1 : 0) != 0, (Object)"backoffTimeMillis should be greater than zero.");
            this.maxAttempts = maxAttempts;
            this.backoffTimeMillis = backoffTimeMillis;
        }

        public FixedDelayRetryStrategyBuilder<OUT> ifResult(@Nonnull Predicate<Collection<OUT>> resultRetryPredicate) {
            this.resultPredicate = resultRetryPredicate;
            return this;
        }

        public FixedDelayRetryStrategyBuilder<OUT> ifException(@Nonnull Predicate<Throwable> exceptionRetryPredicate) {
            this.exceptionPredicate = exceptionRetryPredicate;
            return this;
        }

        public FixedDelayRetryStrategy<OUT> build() {
            return new FixedDelayRetryStrategy(this.maxAttempts, this.backoffTimeMillis, this.resultPredicate, this.exceptionPredicate);
        }
    }

    public static class FixedDelayRetryStrategy<OUT>
    implements AsyncRetryStrategy<OUT> {
        private static final long serialVersionUID = 1L;
        private final int maxAttempts;
        private final long backoffTimeMillis;
        private final Predicate<Collection<OUT>> resultPredicate;
        private final Predicate<Throwable> exceptionPredicate;

        private FixedDelayRetryStrategy(int maxAttempts, long backoffTimeMillis, Predicate<Collection<OUT>> resultPredicate, Predicate<Throwable> exceptionPredicate) {
            this.maxAttempts = maxAttempts;
            this.backoffTimeMillis = backoffTimeMillis;
            this.resultPredicate = resultPredicate;
            this.exceptionPredicate = exceptionPredicate;
        }

        @Override
        public boolean canRetry(int currentAttempts) {
            return currentAttempts <= this.maxAttempts;
        }

        @Override
        public AsyncRetryPredicate<OUT> getRetryPredicate() {
            return new RetryPredicate<OUT>(this.resultPredicate, this.exceptionPredicate);
        }

        @Override
        public long getBackoffTimeMillis(int currentAttempts) {
            return this.backoffTimeMillis;
        }
    }

    private static class RetryPredicate<OUT>
    implements AsyncRetryPredicate<OUT> {
        final Predicate<Collection<OUT>> resultPredicate;
        final Predicate<Throwable> exceptionPredicate;

        public RetryPredicate(Predicate<Collection<OUT>> resultPredicate, Predicate<Throwable> exceptionPredicate) {
            this.resultPredicate = resultPredicate;
            this.exceptionPredicate = exceptionPredicate;
        }

        @Override
        public Optional<Predicate<Collection<OUT>>> resultPredicate() {
            return Optional.ofNullable(this.resultPredicate);
        }

        @Override
        public Optional<Predicate<Throwable>> exceptionPredicate() {
            return Optional.ofNullable(this.exceptionPredicate);
        }
    }

    private static class NoRetryStrategy
    implements AsyncRetryStrategy {
        private static final long serialVersionUID = 1L;

        private NoRetryStrategy() {
        }

        @Override
        public boolean canRetry(int currentAttempts) {
            return false;
        }

        @Override
        public long getBackoffTimeMillis(int currentAttempts) {
            return -1L;
        }

        public AsyncRetryPredicate getRetryPredicate() {
            return new RetryPredicate(null, null);
        }
    }
}

