/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.services.glue.model.S3DirectSourceAdditionalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DeltaSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DeltaSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3DeltaSource.getter(S3DeltaSource::name)).setter(S3DeltaSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Paths").getter(S3DeltaSource.getter(S3DeltaSource::paths)).setter(S3DeltaSource.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_DELTA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalDeltaOptions").getter(S3DeltaSource.getter(S3DeltaSource::additionalDeltaOptions)).setter(S3DeltaSource.setter(Builder::additionalDeltaOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDeltaOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<S3DirectSourceAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalOptions").getter(S3DeltaSource.getter(S3DeltaSource::additionalOptions)).setter(S3DeltaSource.setter(Builder::additionalOptions)).constructor(S3DirectSourceAdditionalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(S3DeltaSource.getter(S3DeltaSource::outputSchemas)).setter(S3DeltaSource.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATHS_FIELD, ADDITIONAL_DELTA_OPTIONS_FIELD, ADDITIONAL_OPTIONS_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> paths;
    private final Map<String, String> additionalDeltaOptions;
    private final S3DirectSourceAdditionalOptions additionalOptions;
    private final List<GlueSchema> outputSchemas;

    private S3DeltaSource(BuilderImpl builder) {
        this.name = builder.name;
        this.paths = builder.paths;
        this.additionalDeltaOptions = builder.additionalDeltaOptions;
        this.additionalOptions = builder.additionalOptions;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final boolean hasAdditionalDeltaOptions() {
        return this.additionalDeltaOptions != null && !(this.additionalDeltaOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalDeltaOptions() {
        return this.additionalDeltaOptions;
    }

    public final S3DirectSourceAdditionalOptions additionalOptions() {
        return this.additionalOptions;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDeltaOptions() ? this.additionalDeltaOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeltaSource)) {
            return false;
        }
        S3DeltaSource other = (S3DeltaSource)obj;
        return Objects.equals(this.name(), other.name()) && this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && this.hasAdditionalDeltaOptions() == other.hasAdditionalDeltaOptions() && Objects.equals(this.additionalDeltaOptions(), other.additionalDeltaOptions()) && Objects.equals(this.additionalOptions(), other.additionalOptions()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"S3DeltaSource").add("Name", (Object)this.name()).add("Paths", this.hasPaths() ? this.paths() : null).add("AdditionalDeltaOptions", this.hasAdditionalDeltaOptions() ? this.additionalDeltaOptions() : null).add("AdditionalOptions", (Object)this.additionalOptions()).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "AdditionalDeltaOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalDeltaOptions()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DeltaSource, T> g) {
        return obj -> g.apply((S3DeltaSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> additionalDeltaOptions = DefaultSdkAutoConstructMap.getInstance();
        private S3DirectSourceAdditionalOptions additionalOptions;
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DeltaSource model) {
            this.name(model.name);
            this.paths(model.paths);
            this.additionalDeltaOptions(model.additionalDeltaOptions);
            this.additionalOptions(model.additionalOptions);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = EnclosedInStringPropertiesCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final Map<String, String> getAdditionalDeltaOptions() {
            if (this.additionalDeltaOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalDeltaOptions;
        }

        public final void setAdditionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
            this.additionalDeltaOptions = AdditionalOptionsCopier.copy(additionalDeltaOptions);
        }

        @Override
        public final Builder additionalDeltaOptions(Map<String, String> additionalDeltaOptions) {
            this.additionalDeltaOptions = AdditionalOptionsCopier.copy(additionalDeltaOptions);
            return this;
        }

        public final S3DirectSourceAdditionalOptions.Builder getAdditionalOptions() {
            return this.additionalOptions != null ? this.additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(S3DirectSourceAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3DeltaSource build() {
            return new S3DeltaSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DeltaSource> {
        public Builder name(String var1);

        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder additionalDeltaOptions(Map<String, String> var1);

        public Builder additionalOptions(S3DirectSourceAdditionalOptions var1);

        default public Builder additionalOptions(Consumer<S3DirectSourceAdditionalOptions.Builder> additionalOptions) {
            return this.additionalOptions((S3DirectSourceAdditionalOptions)((S3DirectSourceAdditionalOptions.Builder)S3DirectSourceAdditionalOptions.builder().applyMutation(additionalOptions)).build());
        }

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

