/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.apache.flink.util.Preconditions;

public class NettyPayloadManager {
    private final Object lock = new Object();
    private final Queue<NettyPayload> queue = new LinkedList<NettyPayload>();
    @GuardedBy(value="lock")
    private final Deque<Integer> backlogs = new LinkedList<Integer>();
    @GuardedBy(value="lock")
    private int lastSegmentId = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NettyPayload nettyPayload) {
        Object object = this.lock;
        synchronized (object) {
            Optional<Buffer> buffer;
            this.queue.add(nettyPayload);
            int segmentId = nettyPayload.getSegmentId();
            if (segmentId != -1 && segmentId != this.lastSegmentId) {
                if (segmentId == 0 || segmentId != this.lastSegmentId + 1) {
                    this.addNewBacklog();
                }
                this.lastSegmentId = segmentId;
            }
            if ((buffer = nettyPayload.getBuffer()).isPresent() && buffer.get().isBuffer()) {
                this.addBacklog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyPayload peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyPayload poll() {
        Object object = this.lock;
        synchronized (object) {
            NettyPayload nettyPayload = this.queue.poll();
            if (nettyPayload != null && nettyPayload.getBuffer().isPresent() && nettyPayload.getBuffer().get().isBuffer()) {
                this.decreaseBacklog();
            }
            return nettyPayload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBacklog() {
        Object object = this.lock;
        synchronized (object) {
            Integer backlog = this.backlogs.peekFirst();
            return backlog == null ? 0 : backlog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    @GuardedBy(value="lock")
    private void addNewBacklog() {
        this.backlogs.addLast(0);
    }

    @GuardedBy(value="lock")
    private void addBacklog() {
        Integer backlog = this.backlogs.pollLast();
        if (backlog == null) {
            this.backlogs.addLast(1);
        } else {
            this.backlogs.addLast(backlog + 1);
        }
    }

    @GuardedBy(value="lock")
    private void decreaseBacklog() {
        int backlog = (Integer)Preconditions.checkNotNull((Object)this.backlogs.pollFirst());
        Preconditions.checkState((backlog > 0 ? 1 : 0) != 0);
        if (backlog > 1) {
            this.backlogs.addFirst(backlog - 1);
        }
    }
}

