/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.util.Preconditions;

public class DefaultVertexParallelismInfo
implements VertexParallelismInformation {
    private final int minParallelism;
    private int parallelism;
    private int maxParallelism;
    private final Function<Integer, Optional<String>> rescaleMaxValidator;

    public DefaultVertexParallelismInfo(int parallelism, int maxParallelism, Function<Integer, Optional<String>> rescaleMaxValidator) {
        this(1, parallelism, maxParallelism, rescaleMaxValidator);
    }

    public DefaultVertexParallelismInfo(int minParallelism, int parallelism, int maxParallelism, Function<Integer, Optional<String>> rescaleMaxValidator) {
        this.minParallelism = minParallelism;
        this.parallelism = DefaultVertexParallelismInfo.checkInitialParallelism(parallelism);
        this.maxParallelism = DefaultVertexParallelismInfo.normalizeAndCheckMaxParallelism(maxParallelism);
        this.rescaleMaxValidator = (Function)Preconditions.checkNotNull(rescaleMaxValidator);
    }

    private static int normalizeAndCheckMaxParallelism(int maxParallelism) {
        if (maxParallelism == Integer.MAX_VALUE) {
            maxParallelism = 32768;
        }
        return DefaultVertexParallelismInfo.checkBounds("max parallelism", maxParallelism);
    }

    private static int checkInitialParallelism(int parallelism) {
        return parallelism == -1 ? parallelism : DefaultVertexParallelismInfo.checkParallelism(parallelism);
    }

    private static int checkParallelism(int parallelism) {
        return DefaultVertexParallelismInfo.checkBounds("parallelism", parallelism);
    }

    private static int checkBounds(String name, int parallelism) {
        Preconditions.checkArgument((parallelism > 0 && parallelism <= 32768 ? 1 : 0) != 0, (String)"Setting %s is not in valid bounds (1..%s), found: %s", (Object[])new Object[]{name, 32768, parallelism});
        return parallelism;
    }

    @Override
    public int getMinParallelism() {
        return this.minParallelism;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @Override
    public void setParallelism(int parallelism) {
        DefaultVertexParallelismInfo.checkParallelism(parallelism);
        Preconditions.checkArgument((parallelism <= this.maxParallelism ? 1 : 0) != 0, (Object)"Vertex's parallelism should be smaller than or equal to vertex's max parallelism.");
        Preconditions.checkState((this.parallelism == -1 ? 1 : 0) != 0, (Object)"Vertex's parallelism can be set only if the vertex's parallelism was not decided yet.");
        this.parallelism = parallelism;
    }

    @Override
    public void setMaxParallelism(int maxParallelism) {
        Optional<String> validationResult = this.rescaleMaxValidator.apply(maxParallelism = DefaultVertexParallelismInfo.normalizeAndCheckMaxParallelism(maxParallelism));
        if (validationResult.isPresent()) {
            throw new IllegalArgumentException(String.format("Rescaling max parallelism from %s to %s is not allowed: %s", this.maxParallelism, maxParallelism, validationResult.get()));
        }
        this.maxParallelism = maxParallelism;
    }

    @Override
    public boolean canRescaleMaxParallelism(int desiredMaxParallelism) {
        if (desiredMaxParallelism == -1) {
            return false;
        }
        return !this.rescaleMaxValidator.apply(DefaultVertexParallelismInfo.normalizeAndCheckMaxParallelism(desiredMaxParallelism)).isPresent();
    }
}

