/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizer.common;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.amoro.optimizer.common.AbstractOptimizerOperator;
import org.apache.amoro.optimizer.common.OptimizerConfig;
import org.apache.amoro.optimizer.common.OptimizerExecutor;
import org.apache.amoro.optimizer.common.OptimizerToucher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimizer {
    private static final Logger LOG = LoggerFactory.getLogger(Optimizer.class);
    private final OptimizerConfig config;
    private final OptimizerToucher toucher;
    private final OptimizerExecutor[] executors;

    public Optimizer(OptimizerConfig config) {
        this(config, () -> new OptimizerToucher(config), i -> new OptimizerExecutor(config, i));
    }

    protected Optimizer(OptimizerConfig config, Supplier<OptimizerToucher> toucherFactory, IntFunction<OptimizerExecutor> executorFactory) {
        this.config = config;
        this.toucher = toucherFactory.get();
        this.executors = new OptimizerExecutor[config.getExecutionParallel()];
        IntStream.range(0, config.getExecutionParallel()).forEach(i -> {
            this.executors[i] = (OptimizerExecutor)executorFactory.apply(i);
        });
        if (config.getResourceId() != null) {
            this.toucher.withRegisterProperty("resource-id", config.getResourceId());
        }
    }

    public void startOptimizing() {
        LOG.info("Starting optimizer with configuration:{}", (Object)this.config);
        Arrays.stream(this.executors).forEach(optimizerExecutor -> new Thread(optimizerExecutor::start, String.format("Optimizer-executor-%d", optimizerExecutor.getThreadId())).start());
        this.toucher.withTokenChangeListener(new SetTokenToExecutors()).start();
    }

    public void stopOptimizing() {
        this.toucher.stop();
        Arrays.stream(this.executors).forEach(AbstractOptimizerOperator::stop);
    }

    public OptimizerToucher getToucher() {
        return this.toucher;
    }

    public OptimizerExecutor[] getExecutors() {
        return this.executors;
    }

    class SetTokenToExecutors
    implements OptimizerToucher.TokenChangeListener {
        SetTokenToExecutors() {
        }

        @Override
        public void tokenChange(String newToken) {
            Arrays.stream(Optimizer.this.executors).forEach(optimizerExecutor -> optimizerExecutor.setToken(newToken));
        }
    }
}

