/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.transport;

import java.io.IOException;
import java.net.Socket;
import org.apache.kerby.kerberos.kerb.transport.AbstractKrbTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTcpTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbUdpTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(KrbNetwork.class);
    private int socketTimeout = 10000;
    private TransportPair tpair;

    public KrbTransport connect(TransportPair tpair) throws IOException {
        AbstractKrbTransport transport;
        block11: {
            this.tpair = tpair;
            transport = null;
            if (tpair.tcpAddress != null) {
                try {
                    transport = this.tcpConnect();
                }
                catch (IOException e1) {
                    if (tpair.udpAddress == null) break block11;
                    try {
                        transport = new KrbUdpTransport(tpair.udpAddress);
                    }
                    catch (Exception e2) {
                        transport = null;
                    }
                }
                catch (Exception e) {
                    LOG.error("TCP connect Failed. " + e.toString());
                }
            } else if (tpair.udpAddress != null) {
                try {
                    transport = new KrbUdpTransport(tpair.udpAddress);
                }
                catch (Exception e3) {
                    transport = null;
                }
            }
        }
        if (transport == null) {
            throw new IOException("Failed to establish the transport");
        }
        return transport;
    }

    private KrbTcpTransport tcpConnect() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.socketTimeout);
        socket.connect(this.tpair.tcpAddress);
        return new KrbTcpTransport(socket);
    }

    public void setSocketTimeout(int milliSeconds) {
        this.socketTimeout = milliSeconds;
    }
}

