/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.net.URL;
import org.apache.spark.ErrorInfo;
import org.apache.spark.ErrorSubInfo;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedMap;
import scala.collection.mutable.ArrayOps;

public final class SparkThrowableHelper$ {
    public static SparkThrowableHelper$ MODULE$;
    private final URL errorClassesUrl;
    private final SortedMap<String, ErrorInfo> errorClassToInfoMap;

    static {
        new SparkThrowableHelper$();
    }

    public URL errorClassesUrl() {
        return this.errorClassesUrl;
    }

    public SortedMap<String, ErrorInfo> errorClassToInfoMap() {
        return this.errorClassToInfoMap;
    }

    public String getMessage(String errorClass, String[] messageParameters, String queryContext) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        ErrorInfo errorInfo = (ErrorInfo)this.errorClassToInfoMap().getOrElse((Object)errorClass, (Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot find error class '").append(errorClass).append("'").toString());
        });
        if (errorInfo.subClass().isDefined()) {
            Map subClass = (Map)errorInfo.subClass().get();
            String subErrorClass = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messageParameters)).head();
            ErrorSubInfo errorSubInfo = (ErrorSubInfo)subClass.getOrElse((Object)subErrorClass, (Function0 & java.io.Serializable & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(30).append("Cannot find sub error class '").append(subErrorClass).append("'").toString());
            });
            String[] subMessageParameters = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messageParameters)).tail();
            tuple22 = new Tuple2((Object)subMessageParameters, (Object)new StringBuilder(0).append(errorInfo.messageFormat()).append(errorSubInfo.messageFormat()).toString());
        } else {
            tuple22 = tuple2 = new Tuple2((Object)messageParameters, (Object)errorInfo.messageFormat());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] displayMessageParameters = (String[])tuple2._1();
        String displayFormat = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)displayMessageParameters, (Object)displayFormat);
        Tuple2 tuple24 = tuple23;
        String[] displayMessageParameters2 = (String[])tuple24._1();
        String displayFormat2 = (String)tuple24._2();
        String displayMessage = String.format(displayFormat2.replaceAll("<[a-zA-Z0-9_-]+>", "%s"), displayMessageParameters2);
        String displayQueryContext = queryContext.isEmpty() ? "" : new StringBuilder(1).append("\n").append(queryContext).toString();
        return new StringBuilder(0).append(displayMessage).append(displayQueryContext).toString();
    }

    public String getMessage$default$3() {
        return "";
    }

    public String getSqlState(String errorClass) {
        return (String)Option$.MODULE$.apply((Object)errorClass).flatMap((Function1 & java.io.Serializable & Serializable)key -> MODULE$.errorClassToInfoMap().get(key)).flatMap((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.sqlState()).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean isInternalError(String errorClass) {
        String string = errorClass;
        String string2 = "INTERNAL_ERROR";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SparkThrowableHelper$() {
        MODULE$ = this;
        this.errorClassesUrl = Utils$.MODULE$.getSparkClassLoader().getResource("error/error-classes.json");
        JsonMapper mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
        this.errorClassToInfoMap = (SortedMap)mapper.readValue(this.errorClassesUrl(), (TypeReference)new TypeReference<SortedMap<String, ErrorInfo>>(){});
    }
}

