/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedThroughput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedThroughput> {
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ReadCapacityUnits").getter(ProvisionedThroughput.getter(ProvisionedThroughput::readCapacityUnits)).setter(ProvisionedThroughput.setter(Builder::readCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()}).build();
    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WriteCapacityUnits").getter(ProvisionedThroughput.getter(ProvisionedThroughput::writeCapacityUnits)).setter(ProvisionedThroughput.setter(Builder::writeCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;

    private ProvisionedThroughput(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    public final Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public final Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughput)) {
            return false;
        }
        ProvisionedThroughput other = (ProvisionedThroughput)obj;
        return Objects.equals(this.readCapacityUnits(), other.readCapacityUnits()) && Objects.equals(this.writeCapacityUnits(), other.writeCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedThroughput").add("ReadCapacityUnits", (Object)this.readCapacityUnits()).add("WriteCapacityUnits", (Object)this.writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.readCapacityUnits()));
            }
            case "WriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.writeCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughput, T> g) {
        return obj -> g.apply((ProvisionedThroughput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long readCapacityUnits;
        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughput model) {
            this.readCapacityUnits(model.readCapacityUnits);
            this.writeCapacityUnits(model.writeCapacityUnits);
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public ProvisionedThroughput build() {
            return new ProvisionedThroughput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedThroughput> {
        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);
    }
}

