/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.MetadataColumns;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class SchemaUtil {
    public static Schema changeWriteSchema(Schema changeTableSchema) {
        Schema changeWriteMetaColumnsSchema = new Schema(new Types.NestedField[]{MetadataColumns.FILE_OFFSET_FILED});
        return TypeUtil.join((Schema)changeTableSchema, (Schema)changeWriteMetaColumnsSchema);
    }

    public static Schema fillUpIdentifierFields(Schema baseSchema, Schema fromSchema, PrimaryKeySpec primaryKeySpec) {
        int schemaId = fromSchema.schemaId();
        Types.StructType struct = fromSchema.asStruct();
        ArrayList fields = Lists.newArrayList((Iterable)struct.fields());
        HashSet identifierFieldIds = Sets.newHashSet((Iterable)baseSchema.identifierFieldIds());
        primaryKeySpec.fields().stream().map(PrimaryKeySpec.PrimaryKeyField::fieldName).forEach(p -> identifierFieldIds.add(baseSchema.findField(p).fieldId()));
        identifierFieldIds.forEach(fieldId -> {
            if (struct.field(fieldId.intValue()) == null) {
                fields.add(baseSchema.findField(fieldId.intValue()));
            }
        });
        return new Schema(schemaId, (List)fields, (Set)identifierFieldIds);
    }

    public static Schema selectInOrder(Schema baseSchema, List<String> fieldNames) {
        Preconditions.checkNotNull(fieldNames);
        Preconditions.checkNotNull((Object)baseSchema);
        SchemaUtil.validateSchemaFields(baseSchema, fieldNames);
        int schemaId = baseSchema.schemaId();
        List fields = fieldNames.stream().map(arg_0 -> ((Schema)baseSchema).findField(arg_0)).collect(Collectors.toList());
        return new Schema(schemaId, fields);
    }

    private static void validateSchemaFields(Schema schema, List<String> requiredFields) {
        Set existingFields = schema.columns().stream().map(Types.NestedField::name).collect(Collectors.toSet());
        for (String requiredField : requiredFields) {
            if (existingFields.contains(requiredField)) continue;
            throw new IllegalArgumentException("The required field in schema is missing: " + requiredField);
        }
    }
}

