/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.AdaptHiveReadConf;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;

public class AdaptHiveParquetReader<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final InputFile input;
    private final Schema expectedSchema;
    private final ParquetReadOptions options;
    private final Function<MessageType, ParquetValueReader<?>> readerFunc;
    private final Expression filter;
    private final boolean reuseContainers;
    private final boolean caseSensitive;
    private final NameMapping nameMapping;
    private AdaptHiveReadConf<T> conf = null;

    public AdaptHiveParquetReader(InputFile input, Schema expectedSchema, ParquetReadOptions options, Function<MessageType, ParquetValueReader<?>> readerFunc, NameMapping nameMapping, Expression filter, boolean reuseContainers, boolean caseSensitive) {
        this.input = input;
        this.expectedSchema = expectedSchema;
        this.options = options;
        this.readerFunc = readerFunc;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
        this.reuseContainers = reuseContainers;
        this.caseSensitive = caseSensitive;
        this.nameMapping = nameMapping;
    }

    private AdaptHiveReadConf<T> init() {
        if (this.conf == null) {
            AdaptHiveReadConf adaptHiveReadConf = new AdaptHiveReadConf(this.input, this.options, this.expectedSchema, this.filter, this.readerFunc, null, this.nameMapping, this.reuseContainers, this.caseSensitive, null);
            this.conf = adaptHiveReadConf.copy();
            return adaptHiveReadConf;
        }
        return this.conf;
    }

    public CloseableIterator<T> iterator() {
        FileIterator<T> iter = new FileIterator<T>(this.init());
        this.addCloseable((Closeable)((Object)iter));
        return iter;
    }

    private static class FileIterator<T>
    implements CloseableIterator<T> {
        private final ParquetFileReader reader;
        private final boolean[] shouldSkip;
        private final ParquetValueReader<T> model;
        private final long totalValues;
        private final boolean reuseContainers;
        private final long[] rowGroupsStartRowPos;
        private int nextRowGroup = 0;
        private long nextRowGroupStart = 0L;
        private long valuesRead = 0L;
        private T last = null;

        FileIterator(AdaptHiveReadConf<T> conf) {
            this.reader = conf.reader();
            this.shouldSkip = conf.shouldSkip();
            this.model = conf.model();
            this.totalValues = conf.totalValues();
            this.reuseContainers = conf.reuseContainers();
            this.rowGroupsStartRowPos = conf.startRowPositions();
        }

        public boolean hasNext() {
            return this.valuesRead < this.totalValues;
        }

        public T next() {
            if (this.valuesRead >= this.nextRowGroupStart) {
                this.advance();
            }
            this.last = this.reuseContainers ? this.model.read(this.last) : this.model.read(null);
            ++this.valuesRead;
            return this.last;
        }

        private void advance() {
            PageReadStore pages;
            while (this.shouldSkip[this.nextRowGroup]) {
                ++this.nextRowGroup;
                this.reader.skipNextRowGroup();
            }
            try {
                pages = this.reader.readNextRowGroup();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            long rowPosition = this.rowGroupsStartRowPos[this.nextRowGroup];
            this.nextRowGroupStart += pages.getRowCount();
            ++this.nextRowGroup;
            this.model.setPageSource(pages, rowPosition);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

