/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExecUtil.class);

    public static int exec(String[] command, List<String> output) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            OutputBufferThread stdOut = new OutputBufferThread(process.getInputStream());
            OutputBufferThread stdErr = new OutputBufferThread(process.getErrorStream());
            stdOut.start();
            stdErr.start();
            int retCode = process.waitFor();
            if (retCode != 0) {
                String error = stdErr.getOutput().stream().collect(Collectors.joining("\n"));
                LOG.error("exec {} failed, reason is {}", (Object)command, (Object)error);
            }
            stdOut.join();
            stdErr.join();
            output.addAll(stdOut.getOutput());
            return retCode;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class OutputBufferThread
    extends Thread {
        private final List<String> output;
        private final InputStream is;

        public OutputBufferThread(InputStream is) {
            this.setDaemon(true);
            this.output = new ArrayList<String>();
            this.is = is;
        }

        @Override
        public void run() {
            try {
                List temp = IOUtils.readLines((InputStream)this.is).stream().collect(Collectors.toList());
                this.output.addAll(temp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public List<String> getOutput() {
            return this.output;
        }
    }
}

