/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.Duration;
import javax.sql.DataSource;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.JDBCSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionHandlerFactory.class);

    public static SessionHandler createSessionHandler(DataSource dataSource, Configurations configurations) {
        DatabaseAdaptor adaptor = new DatabaseAdaptor();
        adaptor.setDatasource(dataSource);
        JDBCSessionDataStore dataStore = new JDBCSessionDataStore();
        dataStore.setDatabaseAdaptor(adaptor);
        dataStore.setSessionTableSchema((JDBCSessionDataStore.SessionTableSchema)new AmoroSessionTableSchema(dataSource));
        SessionHandler handler = new SessionHandler();
        DefaultSessionCache cache = new DefaultSessionCache(handler);
        cache.setSessionDataStore((SessionDataStore)dataStore);
        Duration sessionTimeout = (Duration)configurations.get(AmoroManagementConf.HTTP_SERVER_SESSION_TIMEOUT);
        handler.setMaxInactiveInterval((int)sessionTimeout.getSeconds());
        handler.setSessionCache((SessionCache)cache);
        return handler;
    }

    private static class AmoroSessionTableSchema
    extends JDBCSessionDataStore.SessionTableSchema {
        private final DataSource dataSource;

        public AmoroSessionTableSchema(DataSource dataSource) {
            this.setTableName("http_session");
            this.setIdColumn("session_id");
            this.setContextPathColumn("context_path");
            this.setVirtualHostColumn("virtual_host");
            this.setLastNodeColumn("last_node");
            this.setAccessTimeColumn("access_time");
            this.setLastAccessTimeColumn("last_access_time");
            this.setCreateTimeColumn("create_time");
            this.setCookieTimeColumn("cookie_time");
            this.setLastSavedTimeColumn("last_save_time");
            this.setExpiryTimeColumn("expiry_time");
            this.setMaxIntervalColumn("max_interval");
            this.setMapColumn("data_store");
            this.dataSource = dataSource;
        }

        public void prepareTables() throws SQLException {
            LOG.info("Skip jetty prepare http session tables.");
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(true);
                DatabaseMetaData metaData = connection.getMetaData();
                this._dbAdaptor.adaptTo(metaData);
            }
        }
    }
}

