/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterLogicalOperator {
    AND("AND"),
    OR("OR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterLogicalOperator> VALUE_MAP;
    private final String value;

    private FilterLogicalOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterLogicalOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterLogicalOperator> knownValues() {
        EnumSet<FilterLogicalOperator> knownValues = EnumSet.allOf(FilterLogicalOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterLogicalOperator.class, FilterLogicalOperator::toString);
    }
}

