/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public final class DataSetMetaInfo
implements Serializable {
    private static final int UNKNOWN = -1;
    private final int numRegisteredPartitions;
    private final int numTotalPartitions;
    private final SortedMap<ResultPartitionID, ShuffleDescriptor> shuffleDescriptorsOrderByPartitionId = new TreeMap(Comparator.comparingInt((ToIntFunction<ResultPartitionID> & Serializable & ToIntFunction)o -> o.getPartitionId().getPartitionNumber()));

    private DataSetMetaInfo(int numRegisteredPartitions, int numTotalPartitions) {
        this.numRegisteredPartitions = numRegisteredPartitions;
        this.numTotalPartitions = numTotalPartitions;
    }

    public OptionalInt getNumRegisteredPartitions() {
        return this.numRegisteredPartitions == -1 ? OptionalInt.empty() : OptionalInt.of(this.numRegisteredPartitions);
    }

    public int getNumTotalPartitions() {
        return this.numTotalPartitions;
    }

    public DataSetMetaInfo addShuffleDescriptors(Map<ResultPartitionID, ShuffleDescriptor> shuffleDescriptors) {
        this.shuffleDescriptorsOrderByPartitionId.putAll(shuffleDescriptors);
        return this;
    }

    public Map<ResultPartitionID, ShuffleDescriptor> getShuffleDescriptors() {
        return this.shuffleDescriptorsOrderByPartitionId;
    }

    static DataSetMetaInfo withoutNumRegisteredPartitions(int numTotalPartitions) {
        return new DataSetMetaInfo(-1, numTotalPartitions);
    }

    @VisibleForTesting
    public static DataSetMetaInfo withNumRegisteredPartitions(int numRegisteredPartitions, int numTotalPartitions) {
        Preconditions.checkArgument((numRegisteredPartitions > 0 ? 1 : 0) != 0);
        return new DataSetMetaInfo(numRegisteredPartitions, numTotalPartitions);
    }
}

