/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.failover.FailureHandlingResult;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class FailureHandlingResultSnapshot {
    @Nullable
    private final Execution rootCauseExecution;
    private final Throwable rootCause;
    private final CompletableFuture<Map<String, String>> failureLabels;
    private final long timestamp;
    private final Set<Execution> concurrentlyFailedExecutions;
    private final boolean isRootCause;

    public static FailureHandlingResultSnapshot create(FailureHandlingResult failureHandlingResult, Function<ExecutionVertexID, Collection<Execution>> currentExecutionsLookup) {
        Execution rootCauseExecution = failureHandlingResult.getFailedExecution().orElse(null);
        if (rootCauseExecution != null && !rootCauseExecution.getFailureInfo().isPresent()) {
            throw new IllegalArgumentException(String.format("The failed execution %s didn't provide a failure info.", rootCauseExecution.getAttemptId()));
        }
        Set<Execution> concurrentlyFailedExecutions = failureHandlingResult.getVerticesToRestart().stream().flatMap(id -> ((Collection)currentExecutionsLookup.apply((ExecutionVertexID)id)).stream()).filter(execution -> execution != rootCauseExecution).filter(execution -> execution.getFailureInfo().isPresent()).collect(Collectors.toSet());
        return new FailureHandlingResultSnapshot(rootCauseExecution, ErrorInfo.handleMissingThrowable(failureHandlingResult.getError()), failureHandlingResult.getTimestamp(), failureHandlingResult.getFailureLabels(), concurrentlyFailedExecutions, failureHandlingResult.isRootCause());
    }

    @VisibleForTesting
    FailureHandlingResultSnapshot(@Nullable Execution rootCauseExecution, Throwable rootCause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, Set<Execution> concurrentlyFailedExecutions, boolean isRootCause) {
        Preconditions.checkArgument((rootCauseExecution == null || !concurrentlyFailedExecutions.contains(rootCauseExecution) ? 1 : 0) != 0, (Object)"The rootCauseExecution should not be part of the concurrentlyFailedExecutions map.");
        this.rootCauseExecution = rootCauseExecution;
        this.failureLabels = failureLabels;
        this.rootCause = (Throwable)Preconditions.checkNotNull((Object)rootCause);
        this.timestamp = timestamp;
        this.concurrentlyFailedExecutions = (Set)Preconditions.checkNotNull(concurrentlyFailedExecutions);
        this.isRootCause = isRootCause;
    }

    public Optional<Execution> getRootCauseExecution() {
        return Optional.ofNullable(this.rootCauseExecution);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public CompletableFuture<Map<String, String>> getFailureLabels() {
        return this.failureLabels;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Set<Execution> getConcurrentlyFailedExecution() {
        return Collections.unmodifiableSet(this.concurrentlyFailedExecutions);
    }

    public boolean isRootCause() {
        return this.isRootCause;
    }
}

